package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeETLJobSqlSchema invokes the emr.DescribeETLJobSqlSchema API synchronously
// api document: https://help.aliyun.com/api/emr/describeetljobsqlschema.html
func (client *Client) DescribeETLJobSqlSchema(request *DescribeETLJobSqlSchemaRequest) (response *DescribeETLJobSqlSchemaResponse, err error) {
	response = CreateDescribeETLJobSqlSchemaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeETLJobSqlSchemaWithChan invokes the emr.DescribeETLJobSqlSchema API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljobsqlschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobSqlSchemaWithChan(request *DescribeETLJobSqlSchemaRequest) (<-chan *DescribeETLJobSqlSchemaResponse, <-chan error) {
	responseChan := make(chan *DescribeETLJobSqlSchemaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeETLJobSqlSchema(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeETLJobSqlSchemaWithCallback invokes the emr.DescribeETLJobSqlSchema API asynchronously
// api document: https://help.aliyun.com/api/emr/describeetljobsqlschema.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeETLJobSqlSchemaWithCallback(request *DescribeETLJobSqlSchemaRequest, callback func(response *DescribeETLJobSqlSchemaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeETLJobSqlSchemaResponse
		var err error
		defer close(result)
		response, err = client.DescribeETLJobSqlSchema(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeETLJobSqlSchemaRequest is the request struct for api DescribeETLJobSqlSchema
type DescribeETLJobSqlSchemaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResolveId       string           `position:"Query" name:"ResolveId"`
}

// DescribeETLJobSqlSchemaResponse is the response struct for api DescribeETLJobSqlSchema
type DescribeETLJobSqlSchemaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Schema    Schema `json:"Schema" xml:"Schema"`
}

// CreateDescribeETLJobSqlSchemaRequest creates a request to invoke DescribeETLJobSqlSchema API
func CreateDescribeETLJobSqlSchemaRequest() (request *DescribeETLJobSqlSchemaRequest) {
	request = &DescribeETLJobSqlSchemaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeETLJobSqlSchema", "emr", "openAPI")
	return
}

// CreateDescribeETLJobSqlSchemaResponse creates a response to parse from DescribeETLJobSqlSchema response
func CreateDescribeETLJobSqlSchemaResponse() (response *DescribeETLJobSqlSchemaResponse) {
	response = &DescribeETLJobSqlSchemaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
