package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowVariableCollection invokes the emr.DescribeFlowVariableCollection API synchronously
// api document: https://help.aliyun.com/api/emr/describeflowvariablecollection.html
func (client *Client) DescribeFlowVariableCollection(request *DescribeFlowVariableCollectionRequest) (response *DescribeFlowVariableCollectionResponse, err error) {
	response = CreateDescribeFlowVariableCollectionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowVariableCollectionWithChan invokes the emr.DescribeFlowVariableCollection API asynchronously
// api document: https://help.aliyun.com/api/emr/describeflowvariablecollection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFlowVariableCollectionWithChan(request *DescribeFlowVariableCollectionRequest) (<-chan *DescribeFlowVariableCollectionResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowVariableCollectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowVariableCollection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowVariableCollectionWithCallback invokes the emr.DescribeFlowVariableCollection API asynchronously
// api document: https://help.aliyun.com/api/emr/describeflowvariablecollection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFlowVariableCollectionWithCallback(request *DescribeFlowVariableCollectionRequest, callback func(response *DescribeFlowVariableCollectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowVariableCollectionResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowVariableCollection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowVariableCollectionRequest is the request struct for api DescribeFlowVariableCollection
type DescribeFlowVariableCollectionRequest struct {
	*requests.RpcRequest
	EntityId string `position:"Query" name:"EntityId"`
}

// DescribeFlowVariableCollectionResponse is the response struct for api DescribeFlowVariableCollection
type DescribeFlowVariableCollectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDescribeFlowVariableCollectionRequest creates a request to invoke DescribeFlowVariableCollection API
func CreateDescribeFlowVariableCollectionRequest() (request *DescribeFlowVariableCollectionRequest) {
	request = &DescribeFlowVariableCollectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeFlowVariableCollection", "emr", "openAPI")
	return
}

// CreateDescribeFlowVariableCollectionResponse creates a response to parse from DescribeFlowVariableCollection response
func CreateDescribeFlowVariableCollectionResponse() (response *DescribeFlowVariableCollectionResponse) {
	response = &DescribeFlowVariableCollectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
