package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeParagraph invokes the emr.DescribeParagraph API synchronously
// api document: https://help.aliyun.com/api/emr/describeparagraph.html
func (client *Client) DescribeParagraph(request *DescribeParagraphRequest) (response *DescribeParagraphResponse, err error) {
	response = CreateDescribeParagraphResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeParagraphWithChan invokes the emr.DescribeParagraph API asynchronously
// api document: https://help.aliyun.com/api/emr/describeparagraph.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeParagraphWithChan(request *DescribeParagraphRequest) (<-chan *DescribeParagraphResponse, <-chan error) {
	responseChan := make(chan *DescribeParagraphResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeParagraph(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeParagraphWithCallback invokes the emr.DescribeParagraph API asynchronously
// api document: https://help.aliyun.com/api/emr/describeparagraph.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeParagraphWithCallback(request *DescribeParagraphRequest, callback func(response *DescribeParagraphResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeParagraphResponse
		var err error
		defer close(result)
		response, err = client.DescribeParagraph(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeParagraphRequest is the request struct for api DescribeParagraph
type DescribeParagraphRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NoteId          string           `position:"Query" name:"NoteId"`
	Id              string           `position:"Query" name:"Id"`
}

// DescribeParagraphResponse is the response struct for api DescribeParagraph
type DescribeParagraphResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Paragraph string `json:"Paragraph" xml:"Paragraph"`
}

// CreateDescribeParagraphRequest creates a request to invoke DescribeParagraph API
func CreateDescribeParagraphRequest() (request *DescribeParagraphRequest) {
	request = &DescribeParagraphRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeParagraph", "emr", "openAPI")
	return
}

// CreateDescribeParagraphResponse creates a response to parse from DescribeParagraph response
func CreateDescribeParagraphResponse() (response *DescribeParagraphResponse) {
	response = &DescribeParagraphResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
