package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScalingRule invokes the emr.DescribeScalingRule API synchronously
// api document: https://help.aliyun.com/api/emr/describescalingrule.html
func (client *Client) DescribeScalingRule(request *DescribeScalingRuleRequest) (response *DescribeScalingRuleResponse, err error) {
	response = CreateDescribeScalingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScalingRuleWithChan invokes the emr.DescribeScalingRule API asynchronously
// api document: https://help.aliyun.com/api/emr/describescalingrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScalingRuleWithChan(request *DescribeScalingRuleRequest) (<-chan *DescribeScalingRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeScalingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScalingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScalingRuleWithCallback invokes the emr.DescribeScalingRule API asynchronously
// api document: https://help.aliyun.com/api/emr/describescalingrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScalingRuleWithCallback(request *DescribeScalingRuleRequest, callback func(response *DescribeScalingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScalingRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeScalingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScalingRuleRequest is the request struct for api DescribeScalingRule
type DescribeScalingRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostGroupId     string           `position:"Query" name:"HostGroupId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ScalingRuleId   string           `position:"Query" name:"ScalingRuleId"`
}

// DescribeScalingRuleResponse is the response struct for api DescribeScalingRule
type DescribeScalingRuleResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Id                string            `json:"Id" xml:"Id"`
	GmtCreate         string            `json:"GmtCreate" xml:"GmtCreate"`
	GmtModified       string            `json:"GmtModified" xml:"GmtModified"`
	RuleName          string            `json:"RuleName" xml:"RuleName"`
	RuleCategory      string            `json:"RuleCategory" xml:"RuleCategory"`
	AdjustmentType    string            `json:"AdjustmentType" xml:"AdjustmentType"`
	AdjustmentValue   int               `json:"AdjustmentValue" xml:"AdjustmentValue"`
	Cooldown          int               `json:"Cooldown" xml:"Cooldown"`
	Status            string            `json:"Status" xml:"Status"`
	SchedulerTrigger  SchedulerTrigger  `json:"SchedulerTrigger" xml:"SchedulerTrigger"`
	CloudWatchTrigger CloudWatchTrigger `json:"CloudWatchTrigger" xml:"CloudWatchTrigger"`
}

// CreateDescribeScalingRuleRequest creates a request to invoke DescribeScalingRule API
func CreateDescribeScalingRuleRequest() (request *DescribeScalingRuleRequest) {
	request = &DescribeScalingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeScalingRule", "emr", "openAPI")
	return
}

// CreateDescribeScalingRuleResponse creates a response to parse from DescribeScalingRule response
func CreateDescribeScalingRuleResponse() (response *DescribeScalingRuleResponse) {
	response = &DescribeScalingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
