package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// KillFlow invokes the emr.KillFlow API synchronously
// api document: https://help.aliyun.com/api/emr/killflow.html
func (client *Client) KillFlow(request *KillFlowRequest) (response *KillFlowResponse, err error) {
	response = CreateKillFlowResponse()
	err = client.DoAction(request, response)
	return
}

// KillFlowWithChan invokes the emr.KillFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/killflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KillFlowWithChan(request *KillFlowRequest) (<-chan *KillFlowResponse, <-chan error) {
	responseChan := make(chan *KillFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.KillFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// KillFlowWithCallback invokes the emr.KillFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/killflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KillFlowWithCallback(request *KillFlowRequest, callback func(response *KillFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *KillFlowResponse
		var err error
		defer close(result)
		response, err = client.KillFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// KillFlowRequest is the request struct for api KillFlow
type KillFlowRequest struct {
	*requests.RpcRequest
	FlowInstanceId string `position:"Query" name:"FlowInstanceId"`
	ProjectId      string `position:"Query" name:"ProjectId"`
}

// KillFlowResponse is the response struct for api KillFlow
type KillFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateKillFlowRequest creates a request to invoke KillFlow API
func CreateKillFlowRequest() (request *KillFlowRequest) {
	request = &KillFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "KillFlow", "emr", "openAPI")
	return
}

// CreateKillFlowResponse creates a response to parse from KillFlow response
func CreateKillFlowResponse() (response *KillFlowResponse) {
	response = &KillFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
