package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataSourceSchemaTable invokes the emr.ListDataSourceSchemaTable API synchronously
// api document: https://help.aliyun.com/api/emr/listdatasourceschematable.html
func (client *Client) ListDataSourceSchemaTable(request *ListDataSourceSchemaTableRequest) (response *ListDataSourceSchemaTableResponse, err error) {
	response = CreateListDataSourceSchemaTableResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataSourceSchemaTableWithChan invokes the emr.ListDataSourceSchemaTable API asynchronously
// api document: https://help.aliyun.com/api/emr/listdatasourceschematable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDataSourceSchemaTableWithChan(request *ListDataSourceSchemaTableRequest) (<-chan *ListDataSourceSchemaTableResponse, <-chan error) {
	responseChan := make(chan *ListDataSourceSchemaTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataSourceSchemaTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataSourceSchemaTableWithCallback invokes the emr.ListDataSourceSchemaTable API asynchronously
// api document: https://help.aliyun.com/api/emr/listdatasourceschematable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDataSourceSchemaTableWithCallback(request *ListDataSourceSchemaTableRequest, callback func(response *ListDataSourceSchemaTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataSourceSchemaTableResponse
		var err error
		defer close(result)
		response, err = client.ListDataSourceSchemaTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataSourceSchemaTableRequest is the request struct for api ListDataSourceSchemaTable
type ListDataSourceSchemaTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
	TableName       string           `position:"Query" name:"TableName"`
}

// ListDataSourceSchemaTableResponse is the response struct for api ListDataSourceSchemaTable
type ListDataSourceSchemaTableResponse struct {
	*responses.BaseResponse
	RequestId    string                                `json:"RequestId" xml:"RequestId"`
	DataSourceId string                                `json:"DataSourceId" xml:"DataSourceId"`
	SchemaList   SchemaListInListDataSourceSchemaTable `json:"SchemaList" xml:"SchemaList"`
}

// CreateListDataSourceSchemaTableRequest creates a request to invoke ListDataSourceSchemaTable API
func CreateListDataSourceSchemaTableRequest() (request *ListDataSourceSchemaTableRequest) {
	request = &ListDataSourceSchemaTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListDataSourceSchemaTable", "emr", "openAPI")
	return
}

// CreateListDataSourceSchemaTableResponse creates a response to parse from ListDataSourceSchemaTable response
func CreateListDataSourceSchemaTableResponse() (response *ListDataSourceSchemaTableResponse) {
	response = &ListDataSourceSchemaTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
