package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExecutionPlanInstanceTrend invokes the emr.ListExecutionPlanInstanceTrend API synchronously
// api document: https://help.aliyun.com/api/emr/listexecutionplaninstancetrend.html
func (client *Client) ListExecutionPlanInstanceTrend(request *ListExecutionPlanInstanceTrendRequest) (response *ListExecutionPlanInstanceTrendResponse, err error) {
	response = CreateListExecutionPlanInstanceTrendResponse()
	err = client.DoAction(request, response)
	return
}

// ListExecutionPlanInstanceTrendWithChan invokes the emr.ListExecutionPlanInstanceTrend API asynchronously
// api document: https://help.aliyun.com/api/emr/listexecutionplaninstancetrend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutionPlanInstanceTrendWithChan(request *ListExecutionPlanInstanceTrendRequest) (<-chan *ListExecutionPlanInstanceTrendResponse, <-chan error) {
	responseChan := make(chan *ListExecutionPlanInstanceTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExecutionPlanInstanceTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExecutionPlanInstanceTrendWithCallback invokes the emr.ListExecutionPlanInstanceTrend API asynchronously
// api document: https://help.aliyun.com/api/emr/listexecutionplaninstancetrend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListExecutionPlanInstanceTrendWithCallback(request *ListExecutionPlanInstanceTrendRequest, callback func(response *ListExecutionPlanInstanceTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExecutionPlanInstanceTrendResponse
		var err error
		defer close(result)
		response, err = client.ListExecutionPlanInstanceTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExecutionPlanInstanceTrendRequest is the request struct for api ListExecutionPlanInstanceTrend
type ListExecutionPlanInstanceTrendRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// ListExecutionPlanInstanceTrendResponse is the response struct for api ListExecutionPlanInstanceTrend
type ListExecutionPlanInstanceTrendResponse struct {
	*responses.BaseResponse
	RequestId string                                 `json:"RequestId" xml:"RequestId"`
	Trends    TrendsInListExecutionPlanInstanceTrend `json:"Trends" xml:"Trends"`
}

// CreateListExecutionPlanInstanceTrendRequest creates a request to invoke ListExecutionPlanInstanceTrend API
func CreateListExecutionPlanInstanceTrendRequest() (request *ListExecutionPlanInstanceTrendRequest) {
	request = &ListExecutionPlanInstanceTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListExecutionPlanInstanceTrend", "emr", "openAPI")
	return
}

// CreateListExecutionPlanInstanceTrendResponse creates a response to parse from ListExecutionPlanInstanceTrend response
func CreateListExecutionPlanInstanceTrendResponse() (response *ListExecutionPlanInstanceTrendResponse) {
	response = &ListExecutionPlanInstanceTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
