package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSlsLogstoreInfo invokes the emr.ListSlsLogstoreInfo API synchronously
// api document: https://help.aliyun.com/api/emr/listslslogstoreinfo.html
func (client *Client) ListSlsLogstoreInfo(request *ListSlsLogstoreInfoRequest) (response *ListSlsLogstoreInfoResponse, err error) {
	response = CreateListSlsLogstoreInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ListSlsLogstoreInfoWithChan invokes the emr.ListSlsLogstoreInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/listslslogstoreinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSlsLogstoreInfoWithChan(request *ListSlsLogstoreInfoRequest) (<-chan *ListSlsLogstoreInfoResponse, <-chan error) {
	responseChan := make(chan *ListSlsLogstoreInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSlsLogstoreInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSlsLogstoreInfoWithCallback invokes the emr.ListSlsLogstoreInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/listslslogstoreinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSlsLogstoreInfoWithCallback(request *ListSlsLogstoreInfoRequest, callback func(response *ListSlsLogstoreInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSlsLogstoreInfoResponse
		var err error
		defer close(result)
		response, err = client.ListSlsLogstoreInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSlsLogstoreInfoRequest is the request struct for api ListSlsLogstoreInfo
type ListSlsLogstoreInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ComponentName   string           `position:"Query" name:"ComponentName"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// ListSlsLogstoreInfoResponse is the response struct for api ListSlsLogstoreInfo
type ListSlsLogstoreInfoResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	SlsLogstoreInfoList SlsLogstoreInfoList `json:"SlsLogstoreInfoList" xml:"SlsLogstoreInfoList"`
}

// CreateListSlsLogstoreInfoRequest creates a request to invoke ListSlsLogstoreInfo API
func CreateListSlsLogstoreInfoRequest() (request *ListSlsLogstoreInfoRequest) {
	request = &ListSlsLogstoreInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListSlsLogstoreInfo", "emr", "openAPI")
	return
}

// CreateListSlsLogstoreInfoResponse creates a response to parse from ListSlsLogstoreInfo response
func CreateListSlsLogstoreInfoResponse() (response *ListSlsLogstoreInfoResponse) {
	response = &ListSlsLogstoreInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
