package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreSearchTables invokes the emr.MetastoreSearchTables API synchronously
// api document: https://help.aliyun.com/api/emr/metastoresearchtables.html
func (client *Client) MetastoreSearchTables(request *MetastoreSearchTablesRequest) (response *MetastoreSearchTablesResponse, err error) {
	response = CreateMetastoreSearchTablesResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreSearchTablesWithChan invokes the emr.MetastoreSearchTables API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoresearchtables.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreSearchTablesWithChan(request *MetastoreSearchTablesRequest) (<-chan *MetastoreSearchTablesResponse, <-chan error) {
	responseChan := make(chan *MetastoreSearchTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreSearchTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreSearchTablesWithCallback invokes the emr.MetastoreSearchTables API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoresearchtables.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreSearchTablesWithCallback(request *MetastoreSearchTablesRequest, callback func(response *MetastoreSearchTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreSearchTablesResponse
		var err error
		defer close(result)
		response, err = client.MetastoreSearchTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreSearchTablesRequest is the request struct for api MetastoreSearchTables
type MetastoreSearchTablesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	TableName       string           `position:"Query" name:"TableName"`
}

// MetastoreSearchTablesResponse is the response struct for api MetastoreSearchTables
type MetastoreSearchTablesResponse struct {
	*responses.BaseResponse
	RequestId  string                            `json:"RequestId" xml:"RequestId"`
	TableNames TableNamesInMetastoreSearchTables `json:"TableNames" xml:"TableNames"`
}

// CreateMetastoreSearchTablesRequest creates a request to invoke MetastoreSearchTables API
func CreateMetastoreSearchTablesRequest() (request *MetastoreSearchTablesRequest) {
	request = &MetastoreSearchTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreSearchTables", "emr", "openAPI")
	return
}

// CreateMetastoreSearchTablesResponse creates a response to parse from MetastoreSearchTables response
func CreateMetastoreSearchTablesResponse() (response *MetastoreSearchTablesResponse) {
	response = &MetastoreSearchTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
