package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreUpdateTable invokes the emr.MetastoreUpdateTable API synchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatetable.html
func (client *Client) MetastoreUpdateTable(request *MetastoreUpdateTableRequest) (response *MetastoreUpdateTableResponse, err error) {
	response = CreateMetastoreUpdateTableResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreUpdateTableWithChan invokes the emr.MetastoreUpdateTable API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatetable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreUpdateTableWithChan(request *MetastoreUpdateTableRequest) (<-chan *MetastoreUpdateTableResponse, <-chan error) {
	responseChan := make(chan *MetastoreUpdateTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreUpdateTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreUpdateTableWithCallback invokes the emr.MetastoreUpdateTable API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatetable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreUpdateTableWithCallback(request *MetastoreUpdateTableRequest, callback func(response *MetastoreUpdateTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreUpdateTableResponse
		var err error
		defer close(result)
		response, err = client.MetastoreUpdateTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreUpdateTableRequest is the request struct for api MetastoreUpdateTable
type MetastoreUpdateTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId     requests.Integer                    `position:"Query" name:"ResourceOwnerId"`
	AddColumn           *[]MetastoreUpdateTableAddColumn    `position:"Query" name:"AddColumn"  type:"Repeated"`
	AddPartition        *[]MetastoreUpdateTableAddPartition `position:"Query" name:"AddPartition"  type:"Repeated"`
	DeleteColumnName    *[]string                           `position:"Query" name:"DeleteColumnName"  type:"Repeated"`
	TableId             string                              `position:"Query" name:"TableId"`
	DeletePartitionName *[]string                           `position:"Query" name:"DeletePartitionName"  type:"Repeated"`
}

// MetastoreUpdateTableAddColumn is a repeated param struct in MetastoreUpdateTableRequest
type MetastoreUpdateTableAddColumn struct {
	Name    string `name:"Name"`
	Comment string `name:"Comment"`
	Type    string `name:"Type"`
}

// MetastoreUpdateTableAddPartition is a repeated param struct in MetastoreUpdateTableRequest
type MetastoreUpdateTableAddPartition struct {
	Name    string `name:"Name"`
	Comment string `name:"Comment"`
	Type    string `name:"Type"`
}

// MetastoreUpdateTableResponse is the response struct for api MetastoreUpdateTable
type MetastoreUpdateTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"success" xml:"success"`
}

// CreateMetastoreUpdateTableRequest creates a request to invoke MetastoreUpdateTable API
func CreateMetastoreUpdateTableRequest() (request *MetastoreUpdateTableRequest) {
	request = &MetastoreUpdateTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreUpdateTable", "emr", "openAPI")
	return
}

// CreateMetastoreUpdateTableResponse creates a response to parse from MetastoreUpdateTable response
func CreateMetastoreUpdateTableResponse() (response *MetastoreUpdateTableResponse) {
	response = &MetastoreUpdateTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
