package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExecutionPlan invokes the emr.ModifyExecutionPlan API synchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplan.html
func (client *Client) ModifyExecutionPlan(request *ModifyExecutionPlanRequest) (response *ModifyExecutionPlanResponse, err error) {
	response = CreateModifyExecutionPlanResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExecutionPlanWithChan invokes the emr.ModifyExecutionPlan API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanWithChan(request *ModifyExecutionPlanRequest) (<-chan *ModifyExecutionPlanResponse, <-chan error) {
	responseChan := make(chan *ModifyExecutionPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExecutionPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExecutionPlanWithCallback invokes the emr.ModifyExecutionPlan API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanWithCallback(request *ModifyExecutionPlanRequest, callback func(response *ModifyExecutionPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExecutionPlanResponse
		var err error
		defer close(result)
		response, err = client.ModifyExecutionPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExecutionPlanRequest is the request struct for api ModifyExecutionPlan
type ModifyExecutionPlanRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	LogPath                string                                `position:"Query" name:"LogPath"`
	TimeInterval           requests.Integer                      `position:"Query" name:"TimeInterval"`
	ClusterName            string                                `position:"Query" name:"ClusterName"`
	Configurations         string                                `position:"Query" name:"Configurations"`
	IoOptimized            requests.Boolean                      `position:"Query" name:"IoOptimized"`
	SecurityGroupId        string                                `position:"Query" name:"SecurityGroupId"`
	EasEnable              requests.Boolean                      `position:"Query" name:"EasEnable"`
	CreateClusterOnDemand  requests.Boolean                      `position:"Query" name:"CreateClusterOnDemand"`
	StartTime              requests.Integer                      `position:"Query" name:"StartTime"`
	JobIdList              *[]string                             `position:"Query" name:"JobIdList"  type:"Repeated"`
	DayOfMonth             string                                `position:"Query" name:"DayOfMonth"`
	BootstrapAction        *[]ModifyExecutionPlanBootstrapAction `position:"Query" name:"BootstrapAction"  type:"Repeated"`
	UseLocalMetaDb         requests.Boolean                      `position:"Query" name:"UseLocalMetaDb"`
	EmrVer                 string                                `position:"Query" name:"EmrVer"`
	Id                     string                                `position:"Query" name:"Id"`
	UserDefinedEmrEcsRole  string                                `position:"Query" name:"UserDefinedEmrEcsRole"`
	IsOpenPublicIp         requests.Boolean                      `position:"Query" name:"IsOpenPublicIp"`
	ExecutionPlanVersion   requests.Integer                      `position:"Query" name:"ExecutionPlanVersion"`
	ClusterId              string                                `position:"Query" name:"ClusterId"`
	TimeUnit               string                                `position:"Query" name:"TimeUnit"`
	InstanceGeneration     string                                `position:"Query" name:"InstanceGeneration"`
	ClusterType            string                                `position:"Query" name:"ClusterType"`
	VSwitchId              string                                `position:"Query" name:"VSwitchId"`
	OptionSoftWareList     *[]string                             `position:"Query" name:"OptionSoftWareList"  type:"Repeated"`
	VpcId                  string                                `position:"Query" name:"VpcId"`
	NetType                string                                `position:"Query" name:"NetType"`
	WorkflowDefinition     string                                `position:"Query" name:"WorkflowDefinition"`
	EcsOrder               *[]ModifyExecutionPlanEcsOrder        `position:"Query" name:"EcsOrder"  type:"Repeated"`
	Name                   string                                `position:"Query" name:"Name"`
	ZoneId                 string                                `position:"Query" name:"ZoneId"`
	DayOfWeek              string                                `position:"Query" name:"DayOfWeek"`
	UseCustomHiveMetaDB    requests.Boolean                      `position:"Query" name:"UseCustomHiveMetaDB"`
	Strategy               string                                `position:"Query" name:"Strategy"`
	Config                 *[]ModifyExecutionPlanConfig          `position:"Query" name:"Config"  type:"Repeated"`
	HighAvailabilityEnable requests.Boolean                      `position:"Query" name:"HighAvailabilityEnable"`
	InitCustomHiveMetaDB   requests.Boolean                      `position:"Query" name:"InitCustomHiveMetaDB"`
	LogEnable              requests.Boolean                      `position:"Query" name:"LogEnable"`
}

// ModifyExecutionPlanBootstrapAction is a repeated param struct in ModifyExecutionPlanRequest
type ModifyExecutionPlanBootstrapAction struct {
	Path string `name:"Path"`
	Arg  string `name:"Arg"`
	Name string `name:"Name"`
}

// ModifyExecutionPlanEcsOrder is a repeated param struct in ModifyExecutionPlanRequest
type ModifyExecutionPlanEcsOrder struct {
	NodeType     string `name:"NodeType"`
	DiskCount    string `name:"DiskCount"`
	NodeCount    string `name:"NodeCount"`
	DiskCapacity string `name:"DiskCapacity"`
	Index        string `name:"Index"`
	InstanceType string `name:"InstanceType"`
	DiskType     string `name:"DiskType"`
}

// ModifyExecutionPlanConfig is a repeated param struct in ModifyExecutionPlanRequest
type ModifyExecutionPlanConfig struct {
	ConfigKey   string `name:"ConfigKey"`
	FileName    string `name:"FileName"`
	Encrypt     string `name:"Encrypt"`
	Replace     string `name:"Replace"`
	ConfigValue string `name:"ConfigValue"`
	ServiceName string `name:"ServiceName"`
}

// ModifyExecutionPlanResponse is the response struct for api ModifyExecutionPlan
type ModifyExecutionPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyExecutionPlanRequest creates a request to invoke ModifyExecutionPlan API
func CreateModifyExecutionPlanRequest() (request *ModifyExecutionPlanRequest) {
	request = &ModifyExecutionPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyExecutionPlan", "emr", "openAPI")
	return
}

// CreateModifyExecutionPlanResponse creates a response to parse from ModifyExecutionPlan response
func CreateModifyExecutionPlanResponse() (response *ModifyExecutionPlanResponse) {
	response = &ModifyExecutionPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
