package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFlowCategory invokes the emr.ModifyFlowCategory API synchronously
// api document: https://help.aliyun.com/api/emr/modifyflowcategory.html
func (client *Client) ModifyFlowCategory(request *ModifyFlowCategoryRequest) (response *ModifyFlowCategoryResponse, err error) {
	response = CreateModifyFlowCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFlowCategoryWithChan invokes the emr.ModifyFlowCategory API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowcategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowCategoryWithChan(request *ModifyFlowCategoryRequest) (<-chan *ModifyFlowCategoryResponse, <-chan error) {
	responseChan := make(chan *ModifyFlowCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFlowCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFlowCategoryWithCallback invokes the emr.ModifyFlowCategory API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyflowcategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFlowCategoryWithCallback(request *ModifyFlowCategoryRequest, callback func(response *ModifyFlowCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFlowCategoryResponse
		var err error
		defer close(result)
		response, err = client.ModifyFlowCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFlowCategoryRequest is the request struct for api ModifyFlowCategory
type ModifyFlowCategoryRequest struct {
	*requests.RpcRequest
	Name      string `position:"Query" name:"Name"`
	Id        string `position:"Query" name:"Id"`
	ProjectId string `position:"Query" name:"ProjectId"`
	ParentId  string `position:"Query" name:"ParentId"`
}

// ModifyFlowCategoryResponse is the response struct for api ModifyFlowCategory
type ModifyFlowCategoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateModifyFlowCategoryRequest creates a request to invoke ModifyFlowCategory API
func CreateModifyFlowCategoryRequest() (request *ModifyFlowCategoryRequest) {
	request = &ModifyFlowCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyFlowCategory", "emr", "openAPI")
	return
}

// CreateModifyFlowCategoryResponse creates a response to parse from ModifyFlowCategory response
func CreateModifyFlowCategoryResponse() (response *ModifyFlowCategoryResponse) {
	response = &ModifyFlowCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
