package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAlarmRules invokes the emr.QueryAlarmRules API synchronously
// api document: https://help.aliyun.com/api/emr/queryalarmrules.html
func (client *Client) QueryAlarmRules(request *QueryAlarmRulesRequest) (response *QueryAlarmRulesResponse, err error) {
	response = CreateQueryAlarmRulesResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAlarmRulesWithChan invokes the emr.QueryAlarmRules API asynchronously
// api document: https://help.aliyun.com/api/emr/queryalarmrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAlarmRulesWithChan(request *QueryAlarmRulesRequest) (<-chan *QueryAlarmRulesResponse, <-chan error) {
	responseChan := make(chan *QueryAlarmRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAlarmRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAlarmRulesWithCallback invokes the emr.QueryAlarmRules API asynchronously
// api document: https://help.aliyun.com/api/emr/queryalarmrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAlarmRulesWithCallback(request *QueryAlarmRulesRequest, callback func(response *QueryAlarmRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAlarmRulesResponse
		var err error
		defer close(result)
		response, err = client.QueryAlarmRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAlarmRulesRequest is the request struct for api QueryAlarmRules
type QueryAlarmRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// QueryAlarmRulesResponse is the response struct for api QueryAlarmRules
type QueryAlarmRulesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	AlarmList AlarmList `json:"AlarmList" xml:"AlarmList"`
}

// CreateQueryAlarmRulesRequest creates a request to invoke QueryAlarmRules API
func CreateQueryAlarmRulesRequest() (request *QueryAlarmRulesRequest) {
	request = &QueryAlarmRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "QueryAlarmRules", "emr", "openAPI")
	return
}

// CreateQueryAlarmRulesResponse creates a response to parse from QueryAlarmRules response
func CreateQueryAlarmRulesResponse() (response *QueryAlarmRulesResponse) {
	response = &QueryAlarmRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
