package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySlsMetricData invokes the emr.QuerySlsMetricData API synchronously
// api document: https://help.aliyun.com/api/emr/queryslsmetricdata.html
func (client *Client) QuerySlsMetricData(request *QuerySlsMetricDataRequest) (response *QuerySlsMetricDataResponse, err error) {
	response = CreateQuerySlsMetricDataResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySlsMetricDataWithChan invokes the emr.QuerySlsMetricData API asynchronously
// api document: https://help.aliyun.com/api/emr/queryslsmetricdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySlsMetricDataWithChan(request *QuerySlsMetricDataRequest) (<-chan *QuerySlsMetricDataResponse, <-chan error) {
	responseChan := make(chan *QuerySlsMetricDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySlsMetricData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySlsMetricDataWithCallback invokes the emr.QuerySlsMetricData API asynchronously
// api document: https://help.aliyun.com/api/emr/queryslsmetricdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySlsMetricDataWithCallback(request *QuerySlsMetricDataRequest, callback func(response *QuerySlsMetricDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySlsMetricDataResponse
		var err error
		defer close(result)
		response, err = client.QuerySlsMetricData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySlsMetricDataRequest is the request struct for api QuerySlsMetricData
type QuerySlsMetricDataRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Period          requests.Integer `position:"Query" name:"Period"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	StartTimeStamp  requests.Integer `position:"Query" name:"StartTimeStamp"`
	MetricName      string           `position:"Query" name:"MetricName"`
	HostRole        string           `position:"Query" name:"HostRole"`
	EndTimeStamp    requests.Integer `position:"Query" name:"EndTimeStamp"`
}

// QuerySlsMetricDataResponse is the response struct for api QuerySlsMetricData
type QuerySlsMetricDataResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Datapoints Datapoints `json:"Datapoints" xml:"Datapoints"`
}

// CreateQuerySlsMetricDataRequest creates a request to invoke QuerySlsMetricData API
func CreateQuerySlsMetricDataRequest() (request *QuerySlsMetricDataRequest) {
	request = &QuerySlsMetricDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "QuerySlsMetricData", "emr", "openAPI")
	return
}

// CreateQuerySlsMetricDataResponse creates a response to parse from QuerySlsMetricData response
func CreateQuerySlsMetricDataResponse() (response *QuerySlsMetricDataResponse) {
	response = &QuerySlsMetricDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
