package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RerunFlow invokes the emr.RerunFlow API synchronously
// api document: https://help.aliyun.com/api/emr/rerunflow.html
func (client *Client) RerunFlow(request *RerunFlowRequest) (response *RerunFlowResponse, err error) {
	response = CreateRerunFlowResponse()
	err = client.DoAction(request, response)
	return
}

// RerunFlowWithChan invokes the emr.RerunFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/rerunflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RerunFlowWithChan(request *RerunFlowRequest) (<-chan *RerunFlowResponse, <-chan error) {
	responseChan := make(chan *RerunFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RerunFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RerunFlowWithCallback invokes the emr.RerunFlow API asynchronously
// api document: https://help.aliyun.com/api/emr/rerunflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RerunFlowWithCallback(request *RerunFlowRequest, callback func(response *RerunFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RerunFlowResponse
		var err error
		defer close(result)
		response, err = client.RerunFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RerunFlowRequest is the request struct for api RerunFlow
type RerunFlowRequest struct {
	*requests.RpcRequest
	FlowInstanceId string           `position:"Query" name:"FlowInstanceId"`
	ProjectId      string           `position:"Query" name:"ProjectId"`
	ReRunFail      requests.Boolean `position:"Query" name:"ReRunFail"`
}

// RerunFlowResponse is the response struct for api RerunFlow
type RerunFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateRerunFlowRequest creates a request to invoke RerunFlow API
func CreateRerunFlowRequest() (request *RerunFlowRequest) {
	request = &RerunFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RerunFlow", "emr", "openAPI")
	return
}

// CreateRerunFlowResponse creates a response to parse from RerunFlow response
func CreateRerunFlowResponse() (response *RerunFlowResponse) {
	response = &RerunFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
