package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopParagraph invokes the emr.StopParagraph API synchronously
// api document: https://help.aliyun.com/api/emr/stopparagraph.html
func (client *Client) StopParagraph(request *StopParagraphRequest) (response *StopParagraphResponse, err error) {
	response = CreateStopParagraphResponse()
	err = client.DoAction(request, response)
	return
}

// StopParagraphWithChan invokes the emr.StopParagraph API asynchronously
// api document: https://help.aliyun.com/api/emr/stopparagraph.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StopParagraphWithChan(request *StopParagraphRequest) (<-chan *StopParagraphResponse, <-chan error) {
	responseChan := make(chan *StopParagraphResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopParagraph(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopParagraphWithCallback invokes the emr.StopParagraph API asynchronously
// api document: https://help.aliyun.com/api/emr/stopparagraph.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StopParagraphWithCallback(request *StopParagraphRequest, callback func(response *StopParagraphResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopParagraphResponse
		var err error
		defer close(result)
		response, err = client.StopParagraph(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopParagraphRequest is the request struct for api StopParagraph
type StopParagraphRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NoteId          string           `position:"Query" name:"NoteId"`
	Id              string           `position:"Query" name:"Id"`
}

// StopParagraphResponse is the response struct for api StopParagraph
type StopParagraphResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopParagraphRequest creates a request to invoke StopParagraph API
func CreateStopParagraphRequest() (request *StopParagraphRequest) {
	request = &StopParagraphRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "StopParagraph", "emr", "openAPI")
	return
}

// CreateStopParagraphResponse creates a response to parse from StopParagraph response
func CreateStopParagraphResponse() (response *StopParagraphResponse) {
	response = &StopParagraphResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
