package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateETLJobStage invokes the emr.UpdateETLJobStage API synchronously
// api document: https://help.aliyun.com/api/emr/updateetljobstage.html
func (client *Client) UpdateETLJobStage(request *UpdateETLJobStageRequest) (response *UpdateETLJobStageResponse, err error) {
	response = CreateUpdateETLJobStageResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateETLJobStageWithChan invokes the emr.UpdateETLJobStage API asynchronously
// api document: https://help.aliyun.com/api/emr/updateetljobstage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateETLJobStageWithChan(request *UpdateETLJobStageRequest) (<-chan *UpdateETLJobStageResponse, <-chan error) {
	responseChan := make(chan *UpdateETLJobStageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateETLJobStage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateETLJobStageWithCallback invokes the emr.UpdateETLJobStage API asynchronously
// api document: https://help.aliyun.com/api/emr/updateetljobstage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateETLJobStageWithCallback(request *UpdateETLJobStageRequest, callback func(response *UpdateETLJobStageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateETLJobStageResponse
		var err error
		defer close(result)
		response, err = client.UpdateETLJobStage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateETLJobStageRequest is the request struct for api UpdateETLJobStage
type UpdateETLJobStageRequest struct {
	*requests.RpcRequest
	StageName       string           `position:"Query" name:"StageName"`
	StageConf       string           `position:"Query" name:"StageConf"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StageType       string           `position:"Query" name:"StageType"`
	EtlJobId        string           `position:"Query" name:"EtlJobId"`
	StagePlugin     string           `position:"Query" name:"StagePlugin"`
}

// UpdateETLJobStageResponse is the response struct for api UpdateETLJobStage
type UpdateETLJobStageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateETLJobStageRequest creates a request to invoke UpdateETLJobStage API
func CreateUpdateETLJobStageRequest() (request *UpdateETLJobStageRequest) {
	request = &UpdateETLJobStageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UpdateETLJobStage", "emr", "openAPI")
	return
}

// CreateUpdateETLJobStageResponse creates a response to parse from UpdateETLJobStage response
func CreateUpdateETLJobStageResponse() (response *UpdateETLJobStageResponse) {
	response = &UpdateETLJobStageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
