package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFaceSearchGroup invokes the imm.DeleteFaceSearchGroup API synchronously
// api document: https://help.aliyun.com/api/imm/deletefacesearchgroup.html
func (client *Client) DeleteFaceSearchGroup(request *DeleteFaceSearchGroupRequest) (response *DeleteFaceSearchGroupResponse, err error) {
	response = CreateDeleteFaceSearchGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFaceSearchGroupWithChan invokes the imm.DeleteFaceSearchGroup API asynchronously
// api document: https://help.aliyun.com/api/imm/deletefacesearchgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFaceSearchGroupWithChan(request *DeleteFaceSearchGroupRequest) (<-chan *DeleteFaceSearchGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteFaceSearchGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFaceSearchGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFaceSearchGroupWithCallback invokes the imm.DeleteFaceSearchGroup API asynchronously
// api document: https://help.aliyun.com/api/imm/deletefacesearchgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFaceSearchGroupWithCallback(request *DeleteFaceSearchGroupRequest, callback func(response *DeleteFaceSearchGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFaceSearchGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteFaceSearchGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFaceSearchGroupRequest is the request struct for api DeleteFaceSearchGroup
type DeleteFaceSearchGroupRequest struct {
	*requests.RpcRequest
	Project   string `position:"Query" name:"Project"`
	GroupName string `position:"Query" name:"GroupName"`
}

// DeleteFaceSearchGroupResponse is the response struct for api DeleteFaceSearchGroup
type DeleteFaceSearchGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFaceSearchGroupRequest creates a request to invoke DeleteFaceSearchGroup API
func CreateDeleteFaceSearchGroupRequest() (request *DeleteFaceSearchGroupRequest) {
	request = &DeleteFaceSearchGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeleteFaceSearchGroup", "imm", "openAPI")
	return
}

// CreateDeleteFaceSearchGroupResponse creates a response to parse from DeleteFaceSearchGroup response
func CreateDeleteFaceSearchGroupResponse() (response *DeleteFaceSearchGroupResponse) {
	response = &DeleteFaceSearchGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
