package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePhotoProcessTask invokes the imm.DeletePhotoProcessTask API synchronously
// api document: https://help.aliyun.com/api/imm/deletephotoprocesstask.html
func (client *Client) DeletePhotoProcessTask(request *DeletePhotoProcessTaskRequest) (response *DeletePhotoProcessTaskResponse, err error) {
	response = CreateDeletePhotoProcessTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePhotoProcessTaskWithChan invokes the imm.DeletePhotoProcessTask API asynchronously
// api document: https://help.aliyun.com/api/imm/deletephotoprocesstask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePhotoProcessTaskWithChan(request *DeletePhotoProcessTaskRequest) (<-chan *DeletePhotoProcessTaskResponse, <-chan error) {
	responseChan := make(chan *DeletePhotoProcessTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePhotoProcessTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePhotoProcessTaskWithCallback invokes the imm.DeletePhotoProcessTask API asynchronously
// api document: https://help.aliyun.com/api/imm/deletephotoprocesstask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeletePhotoProcessTaskWithCallback(request *DeletePhotoProcessTaskRequest, callback func(response *DeletePhotoProcessTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePhotoProcessTaskResponse
		var err error
		defer close(result)
		response, err = client.DeletePhotoProcessTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePhotoProcessTaskRequest is the request struct for api DeletePhotoProcessTask
type DeletePhotoProcessTaskRequest struct {
	*requests.RpcRequest
	Project string `position:"Query" name:"Project"`
	TaskId  string `position:"Query" name:"TaskId"`
}

// DeletePhotoProcessTaskResponse is the response struct for api DeletePhotoProcessTask
type DeletePhotoProcessTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePhotoProcessTaskRequest creates a request to invoke DeletePhotoProcessTask API
func CreateDeletePhotoProcessTaskRequest() (request *DeletePhotoProcessTaskRequest) {
	request = &DeletePhotoProcessTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeletePhotoProcessTask", "imm", "openAPI")
	return
}

// CreateDeletePhotoProcessTaskResponse creates a response to parse from DeletePhotoProcessTask response
func CreateDeletePhotoProcessTaskResponse() (response *DeletePhotoProcessTaskResponse) {
	response = &DeletePhotoProcessTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
