package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVideoTask invokes the imm.DeleteVideoTask API synchronously
// api document: https://help.aliyun.com/api/imm/deletevideotask.html
func (client *Client) DeleteVideoTask(request *DeleteVideoTaskRequest) (response *DeleteVideoTaskResponse, err error) {
	response = CreateDeleteVideoTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVideoTaskWithChan invokes the imm.DeleteVideoTask API asynchronously
// api document: https://help.aliyun.com/api/imm/deletevideotask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteVideoTaskWithChan(request *DeleteVideoTaskRequest) (<-chan *DeleteVideoTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteVideoTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVideoTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVideoTaskWithCallback invokes the imm.DeleteVideoTask API asynchronously
// api document: https://help.aliyun.com/api/imm/deletevideotask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteVideoTaskWithCallback(request *DeleteVideoTaskRequest, callback func(response *DeleteVideoTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVideoTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteVideoTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVideoTaskRequest is the request struct for api DeleteVideoTask
type DeleteVideoTaskRequest struct {
	*requests.RpcRequest
	TaskType string `position:"Query" name:"TaskType"`
	Project  string `position:"Query" name:"Project"`
	TaskId   string `position:"Query" name:"TaskId"`
}

// DeleteVideoTaskResponse is the response struct for api DeleteVideoTask
type DeleteVideoTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVideoTaskRequest creates a request to invoke DeleteVideoTask API
func CreateDeleteVideoTaskRequest() (request *DeleteVideoTaskRequest) {
	request = &DeleteVideoTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeleteVideoTask", "imm", "openAPI")
	return
}

// CreateDeleteVideoTaskResponse creates a response to parse from DeleteVideoTask response
func CreateDeleteVideoTaskResponse() (response *DeleteVideoTaskResponse) {
	response = &DeleteVideoTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
