package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InvokeThingService invokes the iot.InvokeThingService API synchronously
// api document: https://help.aliyun.com/api/iot/invokethingservice.html
func (client *Client) InvokeThingService(request *InvokeThingServiceRequest) (response *InvokeThingServiceResponse, err error) {
	response = CreateInvokeThingServiceResponse()
	err = client.DoAction(request, response)
	return
}

// InvokeThingServiceWithChan invokes the iot.InvokeThingService API asynchronously
// api document: https://help.aliyun.com/api/iot/invokethingservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InvokeThingServiceWithChan(request *InvokeThingServiceRequest) (<-chan *InvokeThingServiceResponse, <-chan error) {
	responseChan := make(chan *InvokeThingServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InvokeThingService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InvokeThingServiceWithCallback invokes the iot.InvokeThingService API asynchronously
// api document: https://help.aliyun.com/api/iot/invokethingservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InvokeThingServiceWithCallback(request *InvokeThingServiceRequest, callback func(response *InvokeThingServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InvokeThingServiceResponse
		var err error
		defer close(result)
		response, err = client.InvokeThingService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InvokeThingServiceRequest is the request struct for api InvokeThingService
type InvokeThingServiceRequest struct {
	*requests.RpcRequest
	Args          string `position:"Query" name:"Args"`
	Identifier    string `position:"Query" name:"Identifier"`
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	DeviceName    string `position:"Query" name:"DeviceName"`
	ProductKey    string `position:"Query" name:"ProductKey"`
}

// InvokeThingServiceResponse is the response struct for api InvokeThingService
type InvokeThingServiceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateInvokeThingServiceRequest creates a request to invoke InvokeThingService API
func CreateInvokeThingServiceRequest() (request *InvokeThingServiceRequest) {
	request = &InvokeThingServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "InvokeThingService", "iot", "openAPI")
	return
}

// CreateInvokeThingServiceResponse creates a response to parse from InvokeThingService response
func CreateInvokeThingServiceResponse() (response *InvokeThingServiceResponse) {
	response = &InvokeThingServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
