package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceEventData invokes the iot.QueryDeviceEventData API synchronously
// api document: https://help.aliyun.com/api/iot/querydeviceeventdata.html
func (client *Client) QueryDeviceEventData(request *QueryDeviceEventDataRequest) (response *QueryDeviceEventDataResponse, err error) {
	response = CreateQueryDeviceEventDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceEventDataWithChan invokes the iot.QueryDeviceEventData API asynchronously
// api document: https://help.aliyun.com/api/iot/querydeviceeventdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryDeviceEventDataWithChan(request *QueryDeviceEventDataRequest) (<-chan *QueryDeviceEventDataResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceEventDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceEventData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceEventDataWithCallback invokes the iot.QueryDeviceEventData API asynchronously
// api document: https://help.aliyun.com/api/iot/querydeviceeventdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryDeviceEventDataWithCallback(request *QueryDeviceEventDataRequest, callback func(response *QueryDeviceEventDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceEventDataResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceEventData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceEventDataRequest is the request struct for api QueryDeviceEventData
type QueryDeviceEventDataRequest struct {
	*requests.RpcRequest
	Asc           requests.Integer `position:"Query" name:"Asc"`
	Identifier    string           `position:"Query" name:"Identifier"`
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	EventType     string           `position:"Query" name:"EventType"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
}

// QueryDeviceEventDataResponse is the response struct for api QueryDeviceEventData
type QueryDeviceEventDataResponse struct {
	*responses.BaseResponse
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	Success      bool                       `json:"Success" xml:"Success"`
	Code         string                     `json:"Code" xml:"Code"`
	ErrorMessage string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDeviceEventData `json:"Data" xml:"Data"`
}

// CreateQueryDeviceEventDataRequest creates a request to invoke QueryDeviceEventData API
func CreateQueryDeviceEventDataRequest() (request *QueryDeviceEventDataRequest) {
	request = &QueryDeviceEventDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceEventData", "iot", "openAPI")
	return
}

// CreateQueryDeviceEventDataResponse creates a response to parse from QueryDeviceEventData response
func CreateQueryDeviceEventDataResponse() (response *QueryDeviceEventDataResponse) {
	response = &QueryDeviceEventDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
