package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIteration invokes the ivision.DeleteIteration API synchronously
// api document: https://help.aliyun.com/api/ivision/deleteiteration.html
func (client *Client) DeleteIteration(request *DeleteIterationRequest) (response *DeleteIterationResponse, err error) {
	response = CreateDeleteIterationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIterationWithChan invokes the ivision.DeleteIteration API asynchronously
// api document: https://help.aliyun.com/api/ivision/deleteiteration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteIterationWithChan(request *DeleteIterationRequest) (<-chan *DeleteIterationResponse, <-chan error) {
	responseChan := make(chan *DeleteIterationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIteration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIterationWithCallback invokes the ivision.DeleteIteration API asynchronously
// api document: https://help.aliyun.com/api/ivision/deleteiteration.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteIterationWithCallback(request *DeleteIterationRequest, callback func(response *DeleteIterationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIterationResponse
		var err error
		defer close(result)
		response, err = client.DeleteIteration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIterationRequest is the request struct for api DeleteIteration
type DeleteIterationRequest struct {
	*requests.RpcRequest
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	IterationId string           `position:"Query" name:"IterationId"`
}

// DeleteIterationResponse is the response struct for api DeleteIteration
type DeleteIterationResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	IterationId string `json:"IterationId" xml:"IterationId"`
}

// CreateDeleteIterationRequest creates a request to invoke DeleteIteration API
func CreateDeleteIterationRequest() (request *DeleteIterationRequest) {
	request = &DeleteIterationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DeleteIteration", "ivision", "openAPI")
	return
}

// CreateDeleteIterationResponse creates a response to parse from DeleteIteration response
func CreateDeleteIterationResponse() (response *DeleteIterationResponse) {
	response = &DeleteIterationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
