package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStreamPredicts invokes the ivision.DescribeStreamPredicts API synchronously
// api document: https://help.aliyun.com/api/ivision/describestreampredicts.html
func (client *Client) DescribeStreamPredicts(request *DescribeStreamPredictsRequest) (response *DescribeStreamPredictsResponse, err error) {
	response = CreateDescribeStreamPredictsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStreamPredictsWithChan invokes the ivision.DescribeStreamPredicts API asynchronously
// api document: https://help.aliyun.com/api/ivision/describestreampredicts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStreamPredictsWithChan(request *DescribeStreamPredictsRequest) (<-chan *DescribeStreamPredictsResponse, <-chan error) {
	responseChan := make(chan *DescribeStreamPredictsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStreamPredicts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStreamPredictsWithCallback invokes the ivision.DescribeStreamPredicts API asynchronously
// api document: https://help.aliyun.com/api/ivision/describestreampredicts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStreamPredictsWithCallback(request *DescribeStreamPredictsRequest, callback func(response *DescribeStreamPredictsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStreamPredictsResponse
		var err error
		defer close(result)
		response, err = client.DescribeStreamPredicts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStreamPredictsRequest is the request struct for api DescribeStreamPredicts
type DescribeStreamPredictsRequest struct {
	*requests.RpcRequest
	NextPageToken string           `position:"Query" name:"NextPageToken"`
	PredictIds    string           `position:"Query" name:"PredictIds"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ShowLog       string           `position:"Query" name:"ShowLog"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeStreamPredictsResponse is the response struct for api DescribeStreamPredicts
type DescribeStreamPredictsResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	TotalNum       int            `json:"TotalNum" xml:"TotalNum"`
	CurrentPage    int            `json:"CurrentPage" xml:"CurrentPage"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	NextPageToken  string         `json:"NextPageToken" xml:"NextPageToken"`
	StreamPredicts StreamPredicts `json:"StreamPredicts" xml:"StreamPredicts"`
}

// CreateDescribeStreamPredictsRequest creates a request to invoke DescribeStreamPredicts API
func CreateDescribeStreamPredictsRequest() (request *DescribeStreamPredictsRequest) {
	request = &DescribeStreamPredictsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DescribeStreamPredicts", "ivision", "openAPI")
	return
}

// CreateDescribeStreamPredictsResponse creates a response to parse from DescribeStreamPredicts response
func CreateDescribeStreamPredictsResponse() (response *DescribeStreamPredictsResponse) {
	response = &DescribeStreamPredictsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
