package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictImage invokes the ivision.PredictImage API synchronously
// api document: https://help.aliyun.com/api/ivision/predictimage.html
func (client *Client) PredictImage(request *PredictImageRequest) (response *PredictImageResponse, err error) {
	response = CreatePredictImageResponse()
	err = client.DoAction(request, response)
	return
}

// PredictImageWithChan invokes the ivision.PredictImage API asynchronously
// api document: https://help.aliyun.com/api/ivision/predictimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PredictImageWithChan(request *PredictImageRequest) (<-chan *PredictImageResponse, <-chan error) {
	responseChan := make(chan *PredictImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictImageWithCallback invokes the ivision.PredictImage API asynchronously
// api document: https://help.aliyun.com/api/ivision/predictimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PredictImageWithCallback(request *PredictImageRequest, callback func(response *PredictImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictImageResponse
		var err error
		defer close(result)
		response, err = client.PredictImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictImageRequest is the request struct for api PredictImage
type PredictImageRequest struct {
	*requests.RpcRequest
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	IterationId string           `position:"Query" name:"IterationId"`
	DataUrls    string           `position:"Query" name:"DataUrls"`
}

// PredictImageResponse is the response struct for api PredictImage
type PredictImageResponse struct {
	*responses.BaseResponse
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	PredictDatas PredictDatasInPredictImage `json:"PredictDatas" xml:"PredictDatas"`
}

// CreatePredictImageRequest creates a request to invoke PredictImage API
func CreatePredictImageRequest() (request *PredictImageRequest) {
	request = &PredictImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "PredictImage", "ivision", "openAPI")
	return
}

// CreatePredictImageResponse creates a response to parse from PredictImage response
func CreatePredictImageResponse() (response *PredictImageResponse) {
	response = &PredictImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
