package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveUserDomains invokes the live.DescribeLiveUserDomains API synchronously
// api document: https://help.aliyun.com/api/live/describeliveuserdomains.html
func (client *Client) DescribeLiveUserDomains(request *DescribeLiveUserDomainsRequest) (response *DescribeLiveUserDomainsResponse, err error) {
	response = CreateDescribeLiveUserDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveUserDomainsWithChan invokes the live.DescribeLiveUserDomains API asynchronously
// api document: https://help.aliyun.com/api/live/describeliveuserdomains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveUserDomainsWithChan(request *DescribeLiveUserDomainsRequest) (<-chan *DescribeLiveUserDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveUserDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveUserDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveUserDomainsWithCallback invokes the live.DescribeLiveUserDomains API asynchronously
// api document: https://help.aliyun.com/api/live/describeliveuserdomains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveUserDomainsWithCallback(request *DescribeLiveUserDomainsRequest, callback func(response *DescribeLiveUserDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveUserDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveUserDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveUserDomainsRequest is the request struct for api DescribeLiveUserDomains
type DescribeLiveUserDomainsRequest struct {
	*requests.RpcRequest
	SecurityToken    string           `position:"Query" name:"SecurityToken"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	DomainName       string           `position:"Query" name:"DomainName"`
	RegionName       string           `position:"Query" name:"RegionName"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	DomainStatus     string           `position:"Query" name:"DomainStatus"`
	LiveDomainType   string           `position:"Query" name:"LiveDomainType"`
	DomainSearchType string           `position:"Query" name:"DomainSearchType"`
}

// DescribeLiveUserDomainsResponse is the response struct for api DescribeLiveUserDomains
type DescribeLiveUserDomainsResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Domains    Domains `json:"Domains" xml:"Domains"`
}

// CreateDescribeLiveUserDomainsRequest creates a request to invoke DescribeLiveUserDomains API
func CreateDescribeLiveUserDomainsRequest() (request *DescribeLiveUserDomainsRequest) {
	request = &DescribeLiveUserDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveUserDomains", "live", "openAPI")
	return
}

// CreateDescribeLiveUserDomainsResponse creates a response to parse from DescribeLiveUserDomains response
func CreateDescribeLiveUserDomainsResponse() (response *DescribeLiveUserDomainsResponse) {
	response = &DescribeLiveUserDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
