package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RealTimeRecordCommand invokes the live.RealTimeRecordCommand API synchronously
// api document: https://help.aliyun.com/api/live/realtimerecordcommand.html
func (client *Client) RealTimeRecordCommand(request *RealTimeRecordCommandRequest) (response *RealTimeRecordCommandResponse, err error) {
	response = CreateRealTimeRecordCommandResponse()
	err = client.DoAction(request, response)
	return
}

// RealTimeRecordCommandWithChan invokes the live.RealTimeRecordCommand API asynchronously
// api document: https://help.aliyun.com/api/live/realtimerecordcommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RealTimeRecordCommandWithChan(request *RealTimeRecordCommandRequest) (<-chan *RealTimeRecordCommandResponse, <-chan error) {
	responseChan := make(chan *RealTimeRecordCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RealTimeRecordCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RealTimeRecordCommandWithCallback invokes the live.RealTimeRecordCommand API asynchronously
// api document: https://help.aliyun.com/api/live/realtimerecordcommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RealTimeRecordCommandWithCallback(request *RealTimeRecordCommandRequest, callback func(response *RealTimeRecordCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RealTimeRecordCommandResponse
		var err error
		defer close(result)
		response, err = client.RealTimeRecordCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RealTimeRecordCommandRequest is the request struct for api RealTimeRecordCommand
type RealTimeRecordCommandRequest struct {
	*requests.RpcRequest
	AppName    string           `position:"Query" name:"AppName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Command    string           `position:"Query" name:"Command"`
	StreamName string           `position:"Query" name:"StreamName"`
}

// RealTimeRecordCommandResponse is the response struct for api RealTimeRecordCommand
type RealTimeRecordCommandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRealTimeRecordCommandRequest creates a request to invoke RealTimeRecordCommand API
func CreateRealTimeRecordCommandRequest() (request *RealTimeRecordCommandRequest) {
	request = &RealTimeRecordCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "RealTimeRecordCommand", "live", "openAPI")
	return
}

// CreateRealTimeRecordCommandResponse creates a response to parse from RealTimeRecordCommand response
func CreateRealTimeRecordCommandResponse() (response *RealTimeRecordCommandResponse) {
	response = &RealTimeRecordCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
