package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLicense invokes the mts.GetLicense API synchronously
// api document: https://help.aliyun.com/api/mts/getlicense.html
func (client *Client) GetLicense(request *GetLicenseRequest) (response *GetLicenseResponse, err error) {
	response = CreateGetLicenseResponse()
	err = client.DoAction(request, response)
	return
}

// GetLicenseWithChan invokes the mts.GetLicense API asynchronously
// api document: https://help.aliyun.com/api/mts/getlicense.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLicenseWithChan(request *GetLicenseRequest) (<-chan *GetLicenseResponse, <-chan error) {
	responseChan := make(chan *GetLicenseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLicense(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLicenseWithCallback invokes the mts.GetLicense API asynchronously
// api document: https://help.aliyun.com/api/mts/getlicense.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLicenseWithCallback(request *GetLicenseRequest, callback func(response *GetLicenseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLicenseResponse
		var err error
		defer close(result)
		response, err = client.GetLicense(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLicenseRequest is the request struct for api GetLicense
type GetLicenseRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	Data                 string `position:"Query" name:"Data"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	Header               string `position:"Query" name:"Header"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	MediaId              string `position:"Query" name:"MediaId"`
	Type                 string `position:"Query" name:"Type"`
	LicenseUrl           string `position:"Query" name:"LicenseUrl"`
}

// GetLicenseResponse is the response struct for api GetLicense
type GetLicenseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	License   string `json:"License" xml:"License"`
}

// CreateGetLicenseRequest creates a request to invoke GetLicense API
func CreateGetLicenseRequest() (request *GetLicenseRequest) {
	request = &GetLicenseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "GetLicense", "mts", "openAPI")
	return
}

// CreateGetLicenseResponse creates a response to parse from GetLicense response
func CreateGetLicenseResponse() (response *GetLicenseResponse) {
	response = &GetLicenseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
