package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LogicalDeleteResource invokes the mts.LogicalDeleteResource API synchronously
// api document: https://help.aliyun.com/api/mts/logicaldeleteresource.html
func (client *Client) LogicalDeleteResource(request *LogicalDeleteResourceRequest) (response *LogicalDeleteResourceResponse, err error) {
	response = CreateLogicalDeleteResourceResponse()
	err = client.DoAction(request, response)
	return
}

// LogicalDeleteResourceWithChan invokes the mts.LogicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/mts/logicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LogicalDeleteResourceWithChan(request *LogicalDeleteResourceRequest) (<-chan *LogicalDeleteResourceResponse, <-chan error) {
	responseChan := make(chan *LogicalDeleteResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LogicalDeleteResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LogicalDeleteResourceWithCallback invokes the mts.LogicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/mts/logicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) LogicalDeleteResourceWithCallback(request *LogicalDeleteResourceRequest, callback func(response *LogicalDeleteResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LogicalDeleteResourceResponse
		var err error
		defer close(result)
		response, err = client.LogicalDeleteResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LogicalDeleteResourceRequest is the request struct for api LogicalDeleteResource
type LogicalDeleteResourceRequest struct {
	*requests.RpcRequest
	Country        string           `position:"Query" name:"Country"`
	Hid            requests.Integer `position:"Query" name:"Hid"`
	Success        requests.Boolean `position:"Query" name:"Success"`
	Interrupt      requests.Boolean `position:"Query" name:"Interrupt"`
	GmtWakeup      string           `position:"Query" name:"GmtWakeup"`
	Pk             string           `position:"Query" name:"Pk"`
	Invoker        string           `position:"Query" name:"Invoker"`
	Bid            string           `position:"Query" name:"Bid"`
	Message        string           `position:"Query" name:"Message"`
	TaskExtraData  string           `position:"Query" name:"TaskExtraData"`
	TaskIdentifier string           `position:"Query" name:"TaskIdentifier"`
}

// LogicalDeleteResourceResponse is the response struct for api LogicalDeleteResource
type LogicalDeleteResourceResponse struct {
	*responses.BaseResponse
	Interrupt      bool   `json:"Interrupt" xml:"Interrupt"`
	Invoker        string `json:"Invoker" xml:"Invoker"`
	Pk             string `json:"Pk" xml:"Pk"`
	Bid            string `json:"Bid" xml:"Bid"`
	Hid            int64  `json:"Hid" xml:"Hid"`
	Country        string `json:"Country" xml:"Country"`
	TaskIdentifier string `json:"TaskIdentifier" xml:"TaskIdentifier"`
	TaskExtraData  string `json:"TaskExtraData" xml:"TaskExtraData"`
	GmtWakeup      string `json:"GmtWakeup" xml:"GmtWakeup"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateLogicalDeleteResourceRequest creates a request to invoke LogicalDeleteResource API
func CreateLogicalDeleteResourceRequest() (request *LogicalDeleteResourceRequest) {
	request = &LogicalDeleteResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "LogicalDeleteResource", "mts", "openAPI")
	return
}

// CreateLogicalDeleteResourceResponse creates a response to parse from LogicalDeleteResource response
func CreateLogicalDeleteResourceResponse() (response *LogicalDeleteResourceResponse) {
	response = &LogicalDeleteResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
