//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTieringJob invokes the nas.CreateTieringJob API synchronously
// api document: https://help.aliyun.com/api/nas/createtieringjob.html
func (client *Client) CreateTieringJob(request *CreateTieringJobRequest) (response *CreateTieringJobResponse, err error) {
	response = CreateCreateTieringJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTieringJobWithChan invokes the nas.CreateTieringJob API asynchronously
// api document: https://help.aliyun.com/api/nas/createtieringjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTieringJobWithChan(request *CreateTieringJobRequest) (<-chan *CreateTieringJobResponse, <-chan error) {
	responseChan := make(chan *CreateTieringJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTieringJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTieringJobWithCallback invokes the nas.CreateTieringJob API asynchronously
// api document: https://help.aliyun.com/api/nas/createtieringjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTieringJobWithCallback(request *CreateTieringJobRequest, callback func(response *CreateTieringJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTieringJobResponse
		var err error
		defer close(result)
		response, err = client.CreateTieringJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTieringJobRequest is the request struct for api CreateTieringJob
type CreateTieringJobRequest struct {
	*requests.RpcRequest
	Volume    string           `position:"Query" name:"Volume"`
	Name      string           `position:"Query" name:"Name"`
	Type      string           `position:"Query" name:"Type"`
	Path      string           `position:"Query" name:"Path"`
	Recursive requests.Boolean `position:"Query" name:"Recursive"`
	Policy    string           `position:"Query" name:"Policy"`
	Weekday   requests.Integer `position:"Query" name:"Weekday"`
	Hour      requests.Integer `position:"Query" name:"Hour"`
	Enabled   requests.Boolean `position:"Query" name:"Enabled"`
}

// CreateTieringJobResponse is the response struct for api CreateTieringJob
type CreateTieringJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateTieringJobRequest creates a request to invoke CreateTieringJob API
func CreateCreateTieringJobRequest() (request *CreateTieringJobRequest) {
	request = &CreateTieringJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "CreateTieringJob", "nas", "openAPI")
	return
}

// CreateCreateTieringJobResponse creates a response to parse from CreateTieringJob response
func CreateCreateTieringJobResponse() (response *CreateTieringJobResponse) {
	response = &CreateTieringJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
