package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// NotifyExecution invokes the oos.NotifyExecution API synchronously
// api document: https://help.aliyun.com/api/oos/notifyexecution.html
func (client *Client) NotifyExecution(request *NotifyExecutionRequest) (response *NotifyExecutionResponse, err error) {
	response = CreateNotifyExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// NotifyExecutionWithChan invokes the oos.NotifyExecution API asynchronously
// api document: https://help.aliyun.com/api/oos/notifyexecution.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyExecutionWithChan(request *NotifyExecutionRequest) (<-chan *NotifyExecutionResponse, <-chan error) {
	responseChan := make(chan *NotifyExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.NotifyExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// NotifyExecutionWithCallback invokes the oos.NotifyExecution API asynchronously
// api document: https://help.aliyun.com/api/oos/notifyexecution.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyExecutionWithCallback(request *NotifyExecutionRequest, callback func(response *NotifyExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *NotifyExecutionResponse
		var err error
		defer close(result)
		response, err = client.NotifyExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// NotifyExecutionRequest is the request struct for api NotifyExecution
type NotifyExecutionRequest struct {
	*requests.RpcRequest
	ExecutionId     string `position:"Query" name:"ExecutionId"`
	ExecutionStatus string `position:"Query" name:"ExecutionStatus"`
	NotifyNote      string `position:"Query" name:"NotifyNote"`
	TaskName        string `position:"Query" name:"TaskName"`
	NotifyType      string `position:"Query" name:"NotifyType"`
	Parameters      string `position:"Query" name:"Parameters"`
}

// NotifyExecutionResponse is the response struct for api NotifyExecution
type NotifyExecutionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateNotifyExecutionRequest creates a request to invoke NotifyExecution API
func CreateNotifyExecutionRequest() (request *NotifyExecutionRequest) {
	request = &NotifyExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "NotifyExecution", "oos", "openAPI")
	return
}

// CreateNotifyExecutionResponse creates a response to parse from NotifyExecution response
func CreateNotifyExecutionResponse() (response *NotifyExecutionResponse) {
	response = &NotifyExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
