package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStatisticSummary invokes the pvtz.DescribeStatisticSummary API synchronously
// api document: https://help.aliyun.com/api/pvtz/describestatisticsummary.html
func (client *Client) DescribeStatisticSummary(request *DescribeStatisticSummaryRequest) (response *DescribeStatisticSummaryResponse, err error) {
	response = CreateDescribeStatisticSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStatisticSummaryWithChan invokes the pvtz.DescribeStatisticSummary API asynchronously
// api document: https://help.aliyun.com/api/pvtz/describestatisticsummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStatisticSummaryWithChan(request *DescribeStatisticSummaryRequest) (<-chan *DescribeStatisticSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeStatisticSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStatisticSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStatisticSummaryWithCallback invokes the pvtz.DescribeStatisticSummary API asynchronously
// api document: https://help.aliyun.com/api/pvtz/describestatisticsummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStatisticSummaryWithCallback(request *DescribeStatisticSummaryRequest, callback func(response *DescribeStatisticSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStatisticSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeStatisticSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStatisticSummaryRequest is the request struct for api DescribeStatisticSummary
type DescribeStatisticSummaryRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeStatisticSummaryResponse is the response struct for api DescribeStatisticSummary
type DescribeStatisticSummaryResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	TotalCount      int             `json:"TotalCount" xml:"TotalCount"`
	ZoneRequestTops ZoneRequestTops `json:"ZoneRequestTops" xml:"ZoneRequestTops"`
	VpcRequestTops  VpcRequestTops  `json:"VpcRequestTops" xml:"VpcRequestTops"`
}

// CreateDescribeStatisticSummaryRequest creates a request to invoke DescribeStatisticSummary API
func CreateDescribeStatisticSummaryRequest() (request *DescribeStatisticSummaryRequest) {
	request = &DescribeStatisticSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DescribeStatisticSummary", "pvtz", "openAPI")
	return
}

// CreateDescribeStatisticSummaryResponse creates a response to parse from DescribeStatisticSummary response
func CreateDescribeStatisticSummaryResponse() (response *DescribeStatisticSummaryResponse) {
	response = &DescribeStatisticSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
