package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResourceTypeTemplate invokes the ros.DescribeResourceTypeTemplate API synchronously
// api document: https://help.aliyun.com/api/ros/describeresourcetypetemplate.html
func (client *Client) DescribeResourceTypeTemplate(request *DescribeResourceTypeTemplateRequest) (response *DescribeResourceTypeTemplateResponse, err error) {
	response = CreateDescribeResourceTypeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResourceTypeTemplateWithChan invokes the ros.DescribeResourceTypeTemplate API asynchronously
// api document: https://help.aliyun.com/api/ros/describeresourcetypetemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourceTypeTemplateWithChan(request *DescribeResourceTypeTemplateRequest) (<-chan *DescribeResourceTypeTemplateResponse, <-chan error) {
	responseChan := make(chan *DescribeResourceTypeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResourceTypeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResourceTypeTemplateWithCallback invokes the ros.DescribeResourceTypeTemplate API asynchronously
// api document: https://help.aliyun.com/api/ros/describeresourcetypetemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourceTypeTemplateWithCallback(request *DescribeResourceTypeTemplateRequest, callback func(response *DescribeResourceTypeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResourceTypeTemplateResponse
		var err error
		defer close(result)
		response, err = client.DescribeResourceTypeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResourceTypeTemplateRequest is the request struct for api DescribeResourceTypeTemplate
type DescribeResourceTypeTemplateRequest struct {
	*requests.RoaRequest
	TypeName string `position:"Path" name:"TypeName"`
}

// DescribeResourceTypeTemplateResponse is the response struct for api DescribeResourceTypeTemplate
type DescribeResourceTypeTemplateResponse struct {
	*responses.BaseResponse
}

// CreateDescribeResourceTypeTemplateRequest creates a request to invoke DescribeResourceTypeTemplate API
func CreateDescribeResourceTypeTemplateRequest() (request *DescribeResourceTypeTemplateRequest) {
	request = &DescribeResourceTypeTemplateRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "DescribeResourceTypeTemplate", "/resource_types/[TypeName]/template", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeResourceTypeTemplateResponse creates a response to parse from DescribeResourceTypeTemplate response
func CreateDescribeResourceTypeTemplateResponse() (response *DescribeResourceTypeTemplateResponse) {
	response = &DescribeResourceTypeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
