package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGroupedVul invokes the sas.DescribeGroupedVul API synchronously
// api document: https://help.aliyun.com/api/sas/describegroupedvul.html
func (client *Client) DescribeGroupedVul(request *DescribeGroupedVulRequest) (response *DescribeGroupedVulResponse, err error) {
	response = CreateDescribeGroupedVulResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGroupedVulWithChan invokes the sas.DescribeGroupedVul API asynchronously
// api document: https://help.aliyun.com/api/sas/describegroupedvul.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGroupedVulWithChan(request *DescribeGroupedVulRequest) (<-chan *DescribeGroupedVulResponse, <-chan error) {
	responseChan := make(chan *DescribeGroupedVulResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGroupedVul(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGroupedVulWithCallback invokes the sas.DescribeGroupedVul API asynchronously
// api document: https://help.aliyun.com/api/sas/describegroupedvul.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGroupedVulWithCallback(request *DescribeGroupedVulRequest, callback func(response *DescribeGroupedVulResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGroupedVulResponse
		var err error
		defer close(result)
		response, err = client.DescribeGroupedVul(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGroupedVulRequest is the request struct for api DescribeGroupedVul
type DescribeGroupedVulRequest struct {
	*requests.RpcRequest
	AliasName   string           `position:"Query" name:"AliasName"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Dealed      string           `position:"Query" name:"Dealed"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
	Type        string           `position:"Query" name:"Type"`
	Necessity   string           `position:"Query" name:"Necessity"`
	Uuids       string           `position:"Query" name:"Uuids"`
}

// DescribeGroupedVulResponse is the response struct for api DescribeGroupedVul
type DescribeGroupedVulResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	PageSize        int              `json:"PageSize" xml:"PageSize"`
	CurrentPage     int              `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount      int              `json:"TotalCount" xml:"TotalCount"`
	GroupedVulItems []GroupedVulItem `json:"GroupedVulItems" xml:"GroupedVulItems"`
}

// CreateDescribeGroupedVulRequest creates a request to invoke DescribeGroupedVul API
func CreateDescribeGroupedVulRequest() (request *DescribeGroupedVulRequest) {
	request = &DescribeGroupedVulRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeGroupedVul", "sas", "openAPI")
	return
}

// CreateDescribeGroupedVulResponse creates a response to parse from DescribeGroupedVul response
func CreateDescribeGroupedVulResponse() (response *DescribeGroupedVulResponse) {
	response = &DescribeGroupedVulResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
