package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyRiskSingleResultStatus invokes the sas.ModifyRiskSingleResultStatus API synchronously
// api document: https://help.aliyun.com/api/sas/modifyrisksingleresultstatus.html
func (client *Client) ModifyRiskSingleResultStatus(request *ModifyRiskSingleResultStatusRequest) (response *ModifyRiskSingleResultStatusResponse, err error) {
	response = CreateModifyRiskSingleResultStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyRiskSingleResultStatusWithChan invokes the sas.ModifyRiskSingleResultStatus API asynchronously
// api document: https://help.aliyun.com/api/sas/modifyrisksingleresultstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyRiskSingleResultStatusWithChan(request *ModifyRiskSingleResultStatusRequest) (<-chan *ModifyRiskSingleResultStatusResponse, <-chan error) {
	responseChan := make(chan *ModifyRiskSingleResultStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyRiskSingleResultStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyRiskSingleResultStatusWithCallback invokes the sas.ModifyRiskSingleResultStatus API asynchronously
// api document: https://help.aliyun.com/api/sas/modifyrisksingleresultstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyRiskSingleResultStatusWithCallback(request *ModifyRiskSingleResultStatusRequest, callback func(response *ModifyRiskSingleResultStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyRiskSingleResultStatusResponse
		var err error
		defer close(result)
		response, err = client.ModifyRiskSingleResultStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyRiskSingleResultStatusRequest is the request struct for api ModifyRiskSingleResultStatus
type ModifyRiskSingleResultStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Ids             *[]string        `position:"Query" name:"Ids"  type:"Repeated"`
	Lang            string           `position:"Query" name:"Lang"`
	TaskId          requests.Integer `position:"Query" name:"TaskId"`
	Status          string           `position:"Query" name:"Status"`
}

// ModifyRiskSingleResultStatusResponse is the response struct for api ModifyRiskSingleResultStatus
type ModifyRiskSingleResultStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyRiskSingleResultStatusRequest creates a request to invoke ModifyRiskSingleResultStatus API
func CreateModifyRiskSingleResultStatusRequest() (request *ModifyRiskSingleResultStatusRequest) {
	request = &ModifyRiskSingleResultStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyRiskSingleResultStatus", "sas", "openAPI")
	return
}

// CreateModifyRiskSingleResultStatusResponse creates a response to parse from ModifyRiskSingleResultStatus response
func CreateModifyRiskSingleResultStatusResponse() (response *ModifyRiskSingleResultStatusResponse) {
	response = &ModifyRiskSingleResultStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
