package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteScdnDomainConfigs invokes the scdn.BatchDeleteScdnDomainConfigs API synchronously
// api document: https://help.aliyun.com/api/scdn/batchdeletescdndomainconfigs.html
func (client *Client) BatchDeleteScdnDomainConfigs(request *BatchDeleteScdnDomainConfigsRequest) (response *BatchDeleteScdnDomainConfigsResponse, err error) {
	response = CreateBatchDeleteScdnDomainConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteScdnDomainConfigsWithChan invokes the scdn.BatchDeleteScdnDomainConfigs API asynchronously
// api document: https://help.aliyun.com/api/scdn/batchdeletescdndomainconfigs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchDeleteScdnDomainConfigsWithChan(request *BatchDeleteScdnDomainConfigsRequest) (<-chan *BatchDeleteScdnDomainConfigsResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteScdnDomainConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteScdnDomainConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteScdnDomainConfigsWithCallback invokes the scdn.BatchDeleteScdnDomainConfigs API asynchronously
// api document: https://help.aliyun.com/api/scdn/batchdeletescdndomainconfigs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchDeleteScdnDomainConfigsWithCallback(request *BatchDeleteScdnDomainConfigsRequest, callback func(response *BatchDeleteScdnDomainConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteScdnDomainConfigsResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteScdnDomainConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteScdnDomainConfigsRequest is the request struct for api BatchDeleteScdnDomainConfigs
type BatchDeleteScdnDomainConfigsRequest struct {
	*requests.RpcRequest
	FunctionNames string           `position:"Query" name:"FunctionNames"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerAccount  string           `position:"Query" name:"OwnerAccount"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// BatchDeleteScdnDomainConfigsResponse is the response struct for api BatchDeleteScdnDomainConfigs
type BatchDeleteScdnDomainConfigsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchDeleteScdnDomainConfigsRequest creates a request to invoke BatchDeleteScdnDomainConfigs API
func CreateBatchDeleteScdnDomainConfigsRequest() (request *BatchDeleteScdnDomainConfigsRequest) {
	request = &BatchDeleteScdnDomainConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "BatchDeleteScdnDomainConfigs", "scdn", "openAPI")
	return
}

// CreateBatchDeleteScdnDomainConfigsResponse creates a response to parse from BatchDeleteScdnDomainConfigs response
func CreateBatchDeleteScdnDomainConfigsResponse() (response *BatchDeleteScdnDomainConfigsResponse) {
	response = &BatchDeleteScdnDomainConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
