package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnIpInfo invokes the scdn.DescribeScdnIpInfo API synchronously
// api document: https://help.aliyun.com/api/scdn/describescdnipinfo.html
func (client *Client) DescribeScdnIpInfo(request *DescribeScdnIpInfoRequest) (response *DescribeScdnIpInfoResponse, err error) {
	response = CreateDescribeScdnIpInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnIpInfoWithChan invokes the scdn.DescribeScdnIpInfo API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdnipinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnIpInfoWithChan(request *DescribeScdnIpInfoRequest) (<-chan *DescribeScdnIpInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnIpInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnIpInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnIpInfoWithCallback invokes the scdn.DescribeScdnIpInfo API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdnipinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnIpInfoWithCallback(request *DescribeScdnIpInfoRequest, callback func(response *DescribeScdnIpInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnIpInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnIpInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnIpInfoRequest is the request struct for api DescribeScdnIpInfo
type DescribeScdnIpInfoRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	IP            string           `position:"Query" name:"IP"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnIpInfoResponse is the response struct for api DescribeScdnIpInfo
type DescribeScdnIpInfoResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Ip          string `json:"Ip" xml:"Ip"`
	ISP         string `json:"ISP" xml:"ISP"`
	IspEname    string `json:"IspEname" xml:"IspEname"`
	Region      string `json:"Region" xml:"Region"`
	RegionEname string `json:"RegionEname" xml:"RegionEname"`
}

// CreateDescribeScdnIpInfoRequest creates a request to invoke DescribeScdnIpInfo API
func CreateDescribeScdnIpInfoRequest() (request *DescribeScdnIpInfoRequest) {
	request = &DescribeScdnIpInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnIpInfo", "scdn", "openAPI")
	return
}

// CreateDescribeScdnIpInfoResponse creates a response to parse from DescribeScdnIpInfo response
func CreateDescribeScdnIpInfoResponse() (response *DescribeScdnIpInfoResponse) {
	response = &DescribeScdnIpInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
