package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StoreMaterialTemporarily invokes the trademark.StoreMaterialTemporarily API synchronously
// api document: https://help.aliyun.com/api/trademark/storematerialtemporarily.html
func (client *Client) StoreMaterialTemporarily(request *StoreMaterialTemporarilyRequest) (response *StoreMaterialTemporarilyResponse, err error) {
	response = CreateStoreMaterialTemporarilyResponse()
	err = client.DoAction(request, response)
	return
}

// StoreMaterialTemporarilyWithChan invokes the trademark.StoreMaterialTemporarily API asynchronously
// api document: https://help.aliyun.com/api/trademark/storematerialtemporarily.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StoreMaterialTemporarilyWithChan(request *StoreMaterialTemporarilyRequest) (<-chan *StoreMaterialTemporarilyResponse, <-chan error) {
	responseChan := make(chan *StoreMaterialTemporarilyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StoreMaterialTemporarily(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StoreMaterialTemporarilyWithCallback invokes the trademark.StoreMaterialTemporarily API asynchronously
// api document: https://help.aliyun.com/api/trademark/storematerialtemporarily.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StoreMaterialTemporarilyWithCallback(request *StoreMaterialTemporarilyRequest, callback func(response *StoreMaterialTemporarilyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StoreMaterialTemporarilyResponse
		var err error
		defer close(result)
		response, err = client.StoreMaterialTemporarily(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StoreMaterialTemporarilyRequest is the request struct for api StoreMaterialTemporarily
type StoreMaterialTemporarilyRequest struct {
	*requests.RpcRequest
	ContactEmail          string `position:"Query" name:"ContactEmail"`
	ContactAddress        string `position:"Query" name:"ContactAddress"`
	EAddress              string `position:"Query" name:"EAddress"`
	Country               string `position:"Query" name:"Country"`
	LegalNoticeOssKey     string `position:"Query" name:"LegalNoticeOssKey"`
	Address               string `position:"Query" name:"Address"`
	Town                  string `position:"Query" name:"Town"`
	ContactNumber         string `position:"Query" name:"ContactNumber"`
	City                  string `position:"Query" name:"City"`
	IdCardOssKey          string `position:"Query" name:"IdCardOssKey"`
	Type                  string `position:"Query" name:"Type"`
	ContactName           string `position:"Query" name:"ContactName"`
	PassportOssKey        string `position:"Query" name:"PassportOssKey"`
	ContactZipcode        string `position:"Query" name:"ContactZipcode"`
	EName                 string `position:"Query" name:"EName"`
	Province              string `position:"Query" name:"Province"`
	BusinessLicenceOssKey string `position:"Query" name:"BusinessLicenceOssKey"`
	Name                  string `position:"Query" name:"Name"`
	CardNumber            string `position:"Query" name:"CardNumber"`
	Region                string `position:"Query" name:"Region"`
	LoaOssKey             string `position:"Query" name:"LoaOssKey"`
}

// StoreMaterialTemporarilyResponse is the response struct for api StoreMaterialTemporarily
type StoreMaterialTemporarilyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateStoreMaterialTemporarilyRequest creates a request to invoke StoreMaterialTemporarily API
func CreateStoreMaterialTemporarilyRequest() (request *StoreMaterialTemporarilyRequest) {
	request = &StoreMaterialTemporarilyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "StoreMaterialTemporarily", "trademark", "openAPI")
	return
}

// CreateStoreMaterialTemporarilyResponse creates a response to parse from StoreMaterialTemporarily response
func CreateStoreMaterialTemporarilyResponse() (response *StoreMaterialTemporarilyResponse) {
	response = &StoreMaterialTemporarilyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
