package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIpv6Gateway invokes the vpc.CreateIpv6Gateway API synchronously
// api document: https://help.aliyun.com/api/vpc/createipv6gateway.html
func (client *Client) CreateIpv6Gateway(request *CreateIpv6GatewayRequest) (response *CreateIpv6GatewayResponse, err error) {
	response = CreateCreateIpv6GatewayResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIpv6GatewayWithChan invokes the vpc.CreateIpv6Gateway API asynchronously
// api document: https://help.aliyun.com/api/vpc/createipv6gateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateIpv6GatewayWithChan(request *CreateIpv6GatewayRequest) (<-chan *CreateIpv6GatewayResponse, <-chan error) {
	responseChan := make(chan *CreateIpv6GatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIpv6Gateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIpv6GatewayWithCallback invokes the vpc.CreateIpv6Gateway API asynchronously
// api document: https://help.aliyun.com/api/vpc/createipv6gateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateIpv6GatewayWithCallback(request *CreateIpv6GatewayRequest, callback func(response *CreateIpv6GatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIpv6GatewayResponse
		var err error
		defer close(result)
		response, err = client.CreateIpv6Gateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIpv6GatewayRequest is the request struct for api CreateIpv6Gateway
type CreateIpv6GatewayRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	Spec                 string           `position:"Query" name:"Spec"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VpcId                string           `position:"Query" name:"VpcId"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateIpv6GatewayResponse is the response struct for api CreateIpv6Gateway
type CreateIpv6GatewayResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Ipv6GatewayId string `json:"Ipv6GatewayId" xml:"Ipv6GatewayId"`
}

// CreateCreateIpv6GatewayRequest creates a request to invoke CreateIpv6Gateway API
func CreateCreateIpv6GatewayRequest() (request *CreateIpv6GatewayRequest) {
	request = &CreateIpv6GatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateIpv6Gateway", "vpc", "openAPI")
	return
}

// CreateCreateIpv6GatewayResponse creates a response to parse from CreateIpv6Gateway response
func CreateCreateIpv6GatewayResponse() (response *CreateIpv6GatewayResponse) {
	response = &CreateIpv6GatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
