package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConfigIndex invokes the webplus.DescribeConfigIndex API synchronously
// api document: https://help.aliyun.com/api/webplus/describeconfigindex.html
func (client *Client) DescribeConfigIndex(request *DescribeConfigIndexRequest) (response *DescribeConfigIndexResponse, err error) {
	response = CreateDescribeConfigIndexResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConfigIndexWithChan invokes the webplus.DescribeConfigIndex API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeconfigindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConfigIndexWithChan(request *DescribeConfigIndexRequest) (<-chan *DescribeConfigIndexResponse, <-chan error) {
	responseChan := make(chan *DescribeConfigIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConfigIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConfigIndexWithCallback invokes the webplus.DescribeConfigIndex API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeconfigindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConfigIndexWithCallback(request *DescribeConfigIndexRequest, callback func(response *DescribeConfigIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConfigIndexResponse
		var err error
		defer close(result)
		response, err = client.DescribeConfigIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConfigIndexRequest is the request struct for api DescribeConfigIndex
type DescribeConfigIndexRequest struct {
	*requests.RoaRequest
	StackId     string `position:"Query" name:"StackId"`
	ProfileName string `position:"Query" name:"ProfileName"`
	EnvId       string `position:"Query" name:"EnvId"`
}

// DescribeConfigIndexResponse is the response struct for api DescribeConfigIndex
type DescribeConfigIndexResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	StackId      string       `json:"StackId" xml:"StackId"`
	StackName    string       `json:"StackName" xml:"StackName"`
	ConfigGroups ConfigGroups `json:"ConfigGroups" xml:"ConfigGroups"`
}

// CreateDescribeConfigIndexRequest creates a request to invoke DescribeConfigIndex API
func CreateDescribeConfigIndexRequest() (request *DescribeConfigIndexRequest) {
	request = &DescribeConfigIndexRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeConfigIndex", "/pop/v1/wam/config/configIndex", "webx", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeConfigIndexResponse creates a response to parse from DescribeConfigIndex response
func CreateDescribeConfigIndexResponse() (response *DescribeConfigIndexResponse) {
	response = &DescribeConfigIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
