package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatherStatsResult invokes the webplus.DescribeGatherStatsResult API synchronously
// api document: https://help.aliyun.com/api/webplus/describegatherstatsresult.html
func (client *Client) DescribeGatherStatsResult(request *DescribeGatherStatsResultRequest) (response *DescribeGatherStatsResultResponse, err error) {
	response = CreateDescribeGatherStatsResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatherStatsResultWithChan invokes the webplus.DescribeGatherStatsResult API asynchronously
// api document: https://help.aliyun.com/api/webplus/describegatherstatsresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGatherStatsResultWithChan(request *DescribeGatherStatsResultRequest) (<-chan *DescribeGatherStatsResultResponse, <-chan error) {
	responseChan := make(chan *DescribeGatherStatsResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatherStatsResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatherStatsResultWithCallback invokes the webplus.DescribeGatherStatsResult API asynchronously
// api document: https://help.aliyun.com/api/webplus/describegatherstatsresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGatherStatsResultWithCallback(request *DescribeGatherStatsResultRequest, callback func(response *DescribeGatherStatsResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatherStatsResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatherStatsResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatherStatsResultRequest is the request struct for api DescribeGatherStatsResult
type DescribeGatherStatsResultRequest struct {
	*requests.RoaRequest
	ChangeId string `position:"Query" name:"ChangeId"`
}

// DescribeGatherStatsResultResponse is the response struct for api DescribeGatherStatsResult
type DescribeGatherStatsResultResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Code              string            `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	GatherStatsResult GatherStatsResult `json:"GatherStatsResult" xml:"GatherStatsResult"`
}

// CreateDescribeGatherStatsResultRequest creates a request to invoke DescribeGatherStatsResult API
func CreateDescribeGatherStatsResultRequest() (request *DescribeGatherStatsResultRequest) {
	request = &DescribeGatherStatsResultRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeGatherStatsResult", "/pop/v1/wam/appEnv/gatherStats", "webx", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeGatherStatsResultResponse creates a response to parse from DescribeGatherStatsResult response
func CreateDescribeGatherStatsResultResponse() (response *DescribeGatherStatsResultResponse) {
	response = &DescribeGatherStatsResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
