package api

/************************************************
  generated by IDE. for [DiskAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *DiskAPI) Reset() *DiskAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *DiskAPI) Offset(offset int) *DiskAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *DiskAPI) Limit(limit int) *DiskAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *DiskAPI) Include(key string) *DiskAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *DiskAPI) Exclude(key string) *DiskAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *DiskAPI) FilterBy(key string, value interface{}) *DiskAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *DiskAPI) FilterMultiBy(key string, value interface{}) *DiskAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *DiskAPI) WithNameLike(name string) *DiskAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *DiskAPI) WithTag(tag string) *DiskAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *DiskAPI) WithTags(tags []string) *DiskAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// WithSizeGib サイズ条件
func (api *DiskAPI) WithSizeGib(size int) *DiskAPI {
	api.FilterBy("SizeMB", size*1024)
	return api
}

// SortBy 指定キーでのソート
func (api *DiskAPI) SortBy(key string, reverse bool) *DiskAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *DiskAPI) SortByName(reverse bool) *DiskAPI {
	api.sortByName(reverse)
	return api
}

// SortBySize サイズでのソート
func (api *DiskAPI) SortBySize(reverse bool) *DiskAPI {
	api.sortBy("SizeMB", reverse)
	return api
}

/************************************************
   To support fluent interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *DiskAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *DiskAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *DiskAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *DiskAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *DiskAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *DiskAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *DiskAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *DiskAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *DiskAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *DiskAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// SetSizeGib サイズ条件
func (api *DiskAPI) SetSizeGib(size int) {
	api.FilterBy("SizeMB", size*1024)
}

// SetSortBy 指定キーでのソート
func (api *DiskAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *DiskAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// SetSortBySize サイズでのソート
func (api *DiskAPI) SetSortBySize(reverse bool) {
	api.sortBy("SizeMB", reverse)
}

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *DiskAPI) New() *sacloud.Disk {
	return sacloud.CreateNewDisk()
}

//func (api *DiskAPI) Create(value *sacloud.Disk) (*sacloud.Disk, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.create(api.createRequest(value), res)
//	})
//}

// Read 読み取り
func (api *DiskAPI) Read(id int64) (*sacloud.Disk, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *DiskAPI) Update(id int64, value *sacloud.Disk) (*sacloud.Disk, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *DiskAPI) Delete(id int64) (*sacloud.Disk, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *DiskAPI) setStateValue(setFunc func(*sacloud.Request)) *DiskAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *DiskAPI) request(f func(*sacloud.Response) error) (*sacloud.Disk, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.Disk, nil
}

func (api *DiskAPI) createRequest(value *sacloud.Disk) *sacloud.Request {
	req := &sacloud.Request{}
	req.Disk = value
	return req
}
