package api

/************************************************
  generated by IDE. for [DNSAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *DNSAPI) Reset() *DNSAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *DNSAPI) Offset(offset int) *DNSAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *DNSAPI) Limit(limit int) *DNSAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *DNSAPI) Include(key string) *DNSAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *DNSAPI) Exclude(key string) *DNSAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *DNSAPI) FilterBy(key string, value interface{}) *DNSAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *DNSAPI) FilterMultiBy(key string, value interface{}) *DNSAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *DNSAPI) WithNameLike(name string) *DNSAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *DNSAPI) WithTag(tag string) *DNSAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *DNSAPI) WithTags(tags []string) *DNSAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *DNSAPI) WithSizeGib(size int) *DNSAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *DNSAPI) WithSharedScope() *DNSAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *DNSAPI) WithUserScope() *DNSAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *DNSAPI) SortBy(key string, reverse bool) *DNSAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *DNSAPI) SortByName(reverse bool) *DNSAPI {
	api.sortByName(reverse)
	return api
}

// func (api *DNSAPI) SortBySize(reverse bool) *DNSAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *DNSAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *DNSAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *DNSAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *DNSAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *DNSAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *DNSAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *DNSAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *DNSAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *DNSAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *DNSAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *DNSAPI) SetSizeGib(size int)  {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *DNSAPI) SetSharedScope()  {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *DNSAPI) SetUserScope()  {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *DNSAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *DNSAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *DNSAPI) SetSortBySize(reverse bool)  {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// func (api *DNSAPI) New() *sacloud.DNS {
// 	return &sacloud.DNS{}
// }

// func (api *DNSAPI) Create(value *sacloud.DNS) (*sacloud.DNS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.create(api.createRequest(value), res)
// 	})
// }

// func (api *DNSAPI) Read(id string) (*sacloud.DNS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.read(id, nil, res)
// 	})
// }

// func (api *DNSAPI) Update(id string, value *sacloud.DNS) (*sacloud.DNS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.update(id, api.createRequest(value), res)
// 	})
// }

// func (api *DNSAPI) Delete(id string) (*sacloud.DNS, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.delete(id, nil, res)
// 	})
// }

/************************************************
  Inner functions
************************************************/

func (api *DNSAPI) setStateValue(setFunc func(*sacloud.Request)) *DNSAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

//func (api *DNSAPI) request(f func(*sacloud.Response) error) (*sacloud.DNS, error) {
//	res := &sacloud.Response{}
//	err := f(res)
//	if err != nil {
//		return nil, err
//	}
//	return res.DNS, nil
//}
//
//func (api *DNSAPI) createRequest(value *sacloud.DNS) *dnsRequest {
//	req := &dnsRequest{}
//	req.CommonServiceDNSItem = value
//	return req
//}
