package api

/************************************************
  generated by IDE. for [InterfaceAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *InterfaceAPI) Reset() *InterfaceAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *InterfaceAPI) Offset(offset int) *InterfaceAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *InterfaceAPI) Limit(limit int) *InterfaceAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *InterfaceAPI) Include(key string) *InterfaceAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *InterfaceAPI) Exclude(key string) *InterfaceAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *InterfaceAPI) FilterBy(key string, value interface{}) *InterfaceAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *InterfaceAPI) FilterMultiBy(key string, value interface{}) *InterfaceAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *InterfaceAPI) WithNameLike(name string) *InterfaceAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *InterfaceAPI) WithTag(tag string) *InterfaceAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *InterfaceAPI) WithTags(tags []string) *InterfaceAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *InterfaceAPI) WithSizeGib(size int) *InterfaceAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *InterfaceAPI) WithSharedScope() *InterfaceAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *InterfaceAPI) WithUserScope() *InterfaceAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *InterfaceAPI) SortBy(key string, reverse bool) *InterfaceAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *InterfaceAPI) SortByName(reverse bool) *InterfaceAPI {
	api.sortByName(reverse)
	return api
}

// func (api *InterfaceAPI) SortBySize(reverse bool) *InterfaceAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *InterfaceAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *InterfaceAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *InterfaceAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *InterfaceAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *InterfaceAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *InterfaceAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *InterfaceAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *InterfaceAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *InterfaceAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *InterfaceAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *InterfaceAPI) SetSizeGib(size int)  {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *InterfaceAPI) SetSharedScope()  {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *InterfaceAPI) SetUserScope()  {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *InterfaceAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *InterfaceAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *InterfaceAPI) SetSortBySize(reverse bool)  {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *InterfaceAPI) New() *sacloud.Interface {
	return &sacloud.Interface{}
}

// Create 新規作成
func (api *InterfaceAPI) Create(value *sacloud.Interface) (*sacloud.Interface, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *InterfaceAPI) Read(id int64) (*sacloud.Interface, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *InterfaceAPI) Update(id int64, value *sacloud.Interface) (*sacloud.Interface, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *InterfaceAPI) Delete(id int64) (*sacloud.Interface, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *InterfaceAPI) setStateValue(setFunc func(*sacloud.Request)) *InterfaceAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *InterfaceAPI) request(f func(*sacloud.Response) error) (*sacloud.Interface, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.Interface, nil
}

func (api *InterfaceAPI) createRequest(value *sacloud.Interface) *sacloud.Request {
	req := &sacloud.Request{}
	req.Interface = value
	return req
}
