package api

/************************************************
  generated by IDE. for [IPv6NetAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のクリア
func (api *IPv6NetAPI) Reset() *IPv6NetAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *IPv6NetAPI) Offset(offset int) *IPv6NetAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *IPv6NetAPI) Limit(limit int) *IPv6NetAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *IPv6NetAPI) Include(key string) *IPv6NetAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *IPv6NetAPI) Exclude(key string) *IPv6NetAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *IPv6NetAPI) FilterBy(key string, value interface{}) *IPv6NetAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *IPv6NetAPI) FilterMultiBy(key string, value interface{}) *IPv6NetAPI {
	api.filterBy(key, value, true)
	return api
}

//func (api *IPv6NetAPI) WithNameLike(name string) *IPv6NetAPI {
//	return api.FilterBy("Name", name)
//}
//
//func (api *IPv6NetAPI) WithTag(tag string) *IPv6NetAPI {
//	return api.FilterBy("Tags.Name", tag)
//}
//func (api *IPv6NetAPI) WithTags(tags []string) *IPv6NetAPI {
//	return api.FilterBy("Tags.Name", []interface{}{tags})
//}

// func (api *IPv6NetAPI) WithSizeGib(size int) *IPv6NetAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *IPv6NetAPI) WithSharedScope() *IPv6NetAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *IPv6NetAPI) WithUserScope() *IPv6NetAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *IPv6NetAPI) SortBy(key string, reverse bool) *IPv6NetAPI {
	api.sortBy(key, reverse)
	return api
}

//func (api *IPv6NetAPI) SortByName(reverse bool) *IPv6NetAPI {
//	api.sortByName(reverse)
//	return api
//}

// func (api *IPv6NetAPI) SortBySize(reverse bool) *IPv6NetAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のクリア
func (api *IPv6NetAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *IPv6NetAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *IPv6NetAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *IPv6NetAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *IPv6NetAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *IPv6NetAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *IPv6NetAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

//func (api *IPv6NetAPI) SetNameLike(name string) {
//	api.FilterBy("Name", name)
//}
//
//func (api *IPv6NetAPI) SetTag(tag string) {
//	api.FilterBy("Tags.Name", tag)
//}
//func (api *IPv6NetAPI) SetTags(tags []string) {
//	api.FilterBy("Tags.Name", []interface{}{tags})
//}

// func (api *IPv6NetAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *IPv6NetAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *IPv6NetAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *IPv6NetAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

//func (api *IPv6NetAPI) SetSortByName(reverse bool) {
//	api.sortByName(reverse)
//}

// func (api *IPv6NetAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

//func (api *IPv6NetAPI) New() *sacloud.IPv6Net {
//	return &sacloud.IPv6Net{}
//}

//func (api *IPv6NetAPI) Create(value *sacloud.IPv6Net) (*sacloud.IPv6Net, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.create(api.createRequest(value), res)
//	})
//}

// Read 読み取り
func (api *IPv6NetAPI) Read(id int64) (*sacloud.IPv6Net, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

//func (api *IPv6NetAPI) Update(id int64, value *sacloud.IPv6Net) (*sacloud.IPv6Net, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.update(id, api.createRequest(value), res)
//	})
//}
//
//func (api *IPv6NetAPI) Delete(id int64) (*sacloud.IPv6Net, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.delete(id, nil, res)
//	})
//}

/************************************************
  Inner functions
************************************************/

func (api *IPv6NetAPI) setStateValue(setFunc func(*sacloud.Request)) *IPv6NetAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *IPv6NetAPI) request(f func(*sacloud.Response) error) (*sacloud.IPv6Net, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.IPv6Net, nil
}

func (api *IPv6NetAPI) createRequest(value *sacloud.IPv6Net) *sacloud.Request {
	req := &sacloud.Request{}
	req.IPv6Net = value
	return req
}
