package api

/************************************************
  generated by IDE. for [SimpleMonitorAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *SimpleMonitorAPI) Reset() *SimpleMonitorAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *SimpleMonitorAPI) Offset(offset int) *SimpleMonitorAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *SimpleMonitorAPI) Limit(limit int) *SimpleMonitorAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *SimpleMonitorAPI) Include(key string) *SimpleMonitorAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *SimpleMonitorAPI) Exclude(key string) *SimpleMonitorAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *SimpleMonitorAPI) FilterBy(key string, value interface{}) *SimpleMonitorAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *SimpleMonitorAPI) FilterMultiBy(key string, value interface{}) *SimpleMonitorAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *SimpleMonitorAPI) WithNameLike(name string) *SimpleMonitorAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *SimpleMonitorAPI) WithTag(tag string) *SimpleMonitorAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *SimpleMonitorAPI) WithTags(tags []string) *SimpleMonitorAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *SimpleMonitorAPI) WithSizeGib(size int) *SimpleMonitorAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *SimpleMonitorAPI) WithSharedScope() *SimpleMonitorAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *SimpleMonitorAPI) WithUserScope() *SimpleMonitorAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *SimpleMonitorAPI) SortBy(key string, reverse bool) *SimpleMonitorAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *SimpleMonitorAPI) SortByName(reverse bool) *SimpleMonitorAPI {
	api.sortByName(reverse)
	return api
}

// func (api *SimpleMonitorAPI) SortBySize(reverse bool) *SimpleMonitorAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *SimpleMonitorAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *SimpleMonitorAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *SimpleMonitorAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *SimpleMonitorAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *SimpleMonitorAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *SimpleMonitorAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *SimpleMonitorAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *SimpleMonitorAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *SimpleMonitorAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *SimpleMonitorAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *SimpleMonitorAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *SimpleMonitorAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *SimpleMonitorAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *SimpleMonitorAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *SimpleMonitorAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *SimpleMonitorAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// func (api *SimpleMonitorAPI) New() *sacloud.SimpleMonitor {
// 	return &sacloud.SimpleMonitor{}
// }

// func (api *SimpleMonitorAPI) Create(value *sacloud.SimpleMonitor) (*sacloud.SimpleMonitor, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.create(api.createRequest(value), res)
// 	})
// }

// func (api *SimpleMonitorAPI) Read(id string) (*sacloud.SimpleMonitor, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.read(id, nil, res)
// 	})
// }

// func (api *SimpleMonitorAPI) Update(id string, value *sacloud.SimpleMonitor) (*sacloud.SimpleMonitor, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.update(id, api.createRequest(value), res)
// 	})
// }

// func (api *SimpleMonitorAPI) Delete(id string) (*sacloud.SimpleMonitor, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.delete(id, nil, res)
// 	})
// }

/************************************************
  Inner functions
************************************************/

func (api *SimpleMonitorAPI) setStateValue(setFunc func(*sacloud.Request)) *SimpleMonitorAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

//func (api *SimpleMonitorAPI) request(f func(*sacloud.Response) error) (*sacloud.SimpleMonitor, error) {
//	res := &sacloud.Response{}
//	err := f(res)
//	if err != nil {
//		return nil, err
//	}
//	return res.SimpleMonitor, nil
//}
//
//func (api *SimpleMonitorAPI) createRequest(value *sacloud.SimpleMonitor) *sacloud.Request {
//	req := &sacloud.Request{}
//	req.SimpleMonitor = value
//	return req
//}
