---
title: "Examples"
date: 2019-03-03T16:39:46+01:00
draft: false
---

## CLI Examples

Assumes the `lego` binary has permission to bind to ports 80 and 443.
You can get a pre-built binary from the [releases](https://github.com/go-acme/lego/releases) page.
If your environment does not allow you to bind to these ports, please read [Port Usage](usage/cli#port-usage).

### Obtain a certificate

```bash
lego --email="foo@bar.com" --domains="example.com" --http run
```

(Find your certificate in the `.lego` folder of current working directory.)

### To renew the certificate

```bash
lego --email="foo@bar.com" --domains="example.com" --http renew
```

### To renew the certificate only if it expires within 45 days

```bash
lego --email="foo@bar.com" --domains="example.com" --http renew --days 45
```

### To renew the certificate (and hook)

The hook is executed only when the certificates are effectively renewed.

```bash
lego --email="foo@bar.com" --domains="example.com" --http renew --renew-hook="./myscript.sh"
```

### Obtain a certificate using the DNS challenge

```bash
AWS_REGION=us-east-1 \
AWS_ACCESS_KEY_ID=my_id \
AWS_SECRET_ACCESS_KEY=my_key \
lego --email="foo@bar.com" --domains="example.com" --dns="route53" run
```

### Obtain a certificate given a certificate signing request (CSR) generated by something else

```bash
lego --email="foo@bar.com" --http --csr=/path/to/csr.pem run
```

(lego will infer the domains to be validated based on the contents of the CSR, so make sure the CSR's Common Name and optional SubjectAltNames are set correctly.)
