// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetQualificationScoreInput struct {
	_ struct{} `type:"structure"`

	// The ID of the QualificationType.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`

	// The ID of the Worker whose Qualification is being updated.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetQualificationScoreInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQualificationScoreInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetQualificationScoreInput"}

	if s.QualificationTypeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if s.WorkerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetQualificationScoreOutput struct {
	_ struct{} `type:"structure"`

	// The Qualification data structure of the Qualification assigned to a user,
	// including the Qualification type and the value (score).
	Qualification *Qualification `type:"structure"`
}

// String returns the string representation
func (s GetQualificationScoreOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetQualificationScore = "GetQualificationScore"

// GetQualificationScoreRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The GetQualificationScore operation returns the value of a Worker's Qualification
// for a given Qualification type.
//
// To get a Worker's Qualification, you must know the Worker's ID. The Worker's
// ID is included in the assignment data returned by the ListAssignmentsForHIT
// operation.
//
// Only the owner of a Qualification type can query the value of a Worker's
// Qualification of that type.
//
//    // Example sending a request using GetQualificationScoreRequest.
//    req := client.GetQualificationScoreRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationScore
func (c *Client) GetQualificationScoreRequest(input *GetQualificationScoreInput) GetQualificationScoreRequest {
	op := &aws.Operation{
		Name:       opGetQualificationScore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQualificationScoreInput{}
	}

	req := c.newRequest(op, input, &GetQualificationScoreOutput{})
	return GetQualificationScoreRequest{Request: req, Input: input, Copy: c.GetQualificationScoreRequest}
}

// GetQualificationScoreRequest is the request type for the
// GetQualificationScore API operation.
type GetQualificationScoreRequest struct {
	*aws.Request
	Input *GetQualificationScoreInput
	Copy  func(*GetQualificationScoreInput) GetQualificationScoreRequest
}

// Send marshals and sends the GetQualificationScore API request.
func (r GetQualificationScoreRequest) Send(ctx context.Context) (*GetQualificationScoreResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetQualificationScoreResponse{
		GetQualificationScoreOutput: r.Request.Data.(*GetQualificationScoreOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetQualificationScoreResponse is the response type for the
// GetQualificationScore API operation.
type GetQualificationScoreResponse struct {
	*GetQualificationScoreOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetQualificationScore request.
func (r *GetQualificationScoreResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
