// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package recaptchaenterprise

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Enum that reprensents the types of annotations.
type AnnotateAssessmentRequest_Annotation int32

const (
	// Default unspecified type.
	AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED AnnotateAssessmentRequest_Annotation = 0
	// Provides information that the event turned out to be legitimate.
	AnnotateAssessmentRequest_LEGITIMATE AnnotateAssessmentRequest_Annotation = 1
	// Provides information that the event turned out to be fraudulent.
	AnnotateAssessmentRequest_FRAUDULENT AnnotateAssessmentRequest_Annotation = 2
	// Provides information that the event was related to a login event in which
	// the user typed the correct password.
	AnnotateAssessmentRequest_PASSWORD_CORRECT AnnotateAssessmentRequest_Annotation = 3
	// Provides information that the event was related to a login event in which
	// the user typed the incorrect password.
	AnnotateAssessmentRequest_PASSWORD_INCORRECT AnnotateAssessmentRequest_Annotation = 4
)

// Enum value maps for AnnotateAssessmentRequest_Annotation.
var (
	AnnotateAssessmentRequest_Annotation_name = map[int32]string{
		0: "ANNOTATION_UNSPECIFIED",
		1: "LEGITIMATE",
		2: "FRAUDULENT",
		3: "PASSWORD_CORRECT",
		4: "PASSWORD_INCORRECT",
	}
	AnnotateAssessmentRequest_Annotation_value = map[string]int32{
		"ANNOTATION_UNSPECIFIED": 0,
		"LEGITIMATE":             1,
		"FRAUDULENT":             2,
		"PASSWORD_CORRECT":       3,
		"PASSWORD_INCORRECT":     4,
	}
)

func (x AnnotateAssessmentRequest_Annotation) Enum() *AnnotateAssessmentRequest_Annotation {
	p := new(AnnotateAssessmentRequest_Annotation)
	*p = x
	return p
}

func (x AnnotateAssessmentRequest_Annotation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotateAssessmentRequest_Annotation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[0].Descriptor()
}

func (AnnotateAssessmentRequest_Annotation) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[0]
}

func (x AnnotateAssessmentRequest_Annotation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotateAssessmentRequest_Annotation.Descriptor instead.
func (AnnotateAssessmentRequest_Annotation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{1, 0}
}

// LINT.IfChange(classification_reason)
// Reasons contributing to the risk analysis verdict.
type RiskAnalysis_ClassificationReason int32

const (
	// Default unspecified type.
	RiskAnalysis_CLASSIFICATION_REASON_UNSPECIFIED RiskAnalysis_ClassificationReason = 0
	// Interactions matched the behavior of an automated agent.
	RiskAnalysis_AUTOMATION RiskAnalysis_ClassificationReason = 1
	// The event originated from an illegitimate environment.
	RiskAnalysis_UNEXPECTED_ENVIRONMENT RiskAnalysis_ClassificationReason = 2
	// Traffic volume from the event source is higher than normal.
	RiskAnalysis_TOO_MUCH_TRAFFIC RiskAnalysis_ClassificationReason = 3
	// Interactions with the site were significantly different than expected
	// patterns.
	RiskAnalysis_UNEXPECTED_USAGE_PATTERNS RiskAnalysis_ClassificationReason = 4
	// Too little traffic has been received from this site thus far to generate
	// quality risk analysis.
	RiskAnalysis_LOW_CONFIDENCE_SCORE RiskAnalysis_ClassificationReason = 5
)

// Enum value maps for RiskAnalysis_ClassificationReason.
var (
	RiskAnalysis_ClassificationReason_name = map[int32]string{
		0: "CLASSIFICATION_REASON_UNSPECIFIED",
		1: "AUTOMATION",
		2: "UNEXPECTED_ENVIRONMENT",
		3: "TOO_MUCH_TRAFFIC",
		4: "UNEXPECTED_USAGE_PATTERNS",
		5: "LOW_CONFIDENCE_SCORE",
	}
	RiskAnalysis_ClassificationReason_value = map[string]int32{
		"CLASSIFICATION_REASON_UNSPECIFIED": 0,
		"AUTOMATION":                        1,
		"UNEXPECTED_ENVIRONMENT":            2,
		"TOO_MUCH_TRAFFIC":                  3,
		"UNEXPECTED_USAGE_PATTERNS":         4,
		"LOW_CONFIDENCE_SCORE":              5,
	}
)

func (x RiskAnalysis_ClassificationReason) Enum() *RiskAnalysis_ClassificationReason {
	p := new(RiskAnalysis_ClassificationReason)
	*p = x
	return p
}

func (x RiskAnalysis_ClassificationReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RiskAnalysis_ClassificationReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[1].Descriptor()
}

func (RiskAnalysis_ClassificationReason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[1]
}

func (x RiskAnalysis_ClassificationReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RiskAnalysis_ClassificationReason.Descriptor instead.
func (RiskAnalysis_ClassificationReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{5, 0}
}

// LINT.IfChange
// Enum that represents the types of invalid token reasons.
type TokenProperties_InvalidReason int32

const (
	// Default unspecified type.
	TokenProperties_INVALID_REASON_UNSPECIFIED TokenProperties_InvalidReason = 0
	// If the failure reason was not accounted for.
	TokenProperties_UNKNOWN_INVALID_REASON TokenProperties_InvalidReason = 1
	// The provided user verification token was malformed.
	TokenProperties_MALFORMED TokenProperties_InvalidReason = 2
	// The user verification token had expired.
	TokenProperties_EXPIRED TokenProperties_InvalidReason = 3
	// The user verification had already been seen.
	TokenProperties_DUPE TokenProperties_InvalidReason = 4
	// The user verification token was not present.
	TokenProperties_MISSING TokenProperties_InvalidReason = 5
)

// Enum value maps for TokenProperties_InvalidReason.
var (
	TokenProperties_InvalidReason_name = map[int32]string{
		0: "INVALID_REASON_UNSPECIFIED",
		1: "UNKNOWN_INVALID_REASON",
		2: "MALFORMED",
		3: "EXPIRED",
		4: "DUPE",
		5: "MISSING",
	}
	TokenProperties_InvalidReason_value = map[string]int32{
		"INVALID_REASON_UNSPECIFIED": 0,
		"UNKNOWN_INVALID_REASON":     1,
		"MALFORMED":                  2,
		"EXPIRED":                    3,
		"DUPE":                       4,
		"MISSING":                    5,
	}
)

func (x TokenProperties_InvalidReason) Enum() *TokenProperties_InvalidReason {
	p := new(TokenProperties_InvalidReason)
	*p = x
	return p
}

func (x TokenProperties_InvalidReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TokenProperties_InvalidReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[2].Descriptor()
}

func (TokenProperties_InvalidReason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[2]
}

func (x TokenProperties_InvalidReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TokenProperties_InvalidReason.Descriptor instead.
func (TokenProperties_InvalidReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{6, 0}
}

// Enum that represents the integration types for web keys.
type WebKeySettings_IntegrationType int32

const (
	// Default type that indicates this enum hasn't been specified. This is not
	// a valid IntegrationType, one of the other types must be specified
	// instead.
	WebKeySettings_INTEGRATION_TYPE_UNSPECIFIED WebKeySettings_IntegrationType = 0
	// Only used to produce scores. It doesn't display the "I'm not a robot"
	// checkbox and never shows captcha challenges.
	WebKeySettings_SCORE WebKeySettings_IntegrationType = 1
	// Displays the "I'm not a robot" checkbox and may show captcha challenges
	// after it is checked.
	WebKeySettings_CHECKBOX WebKeySettings_IntegrationType = 2
	// Doesn't display the "I'm not a robot" checkbox, but may show captcha
	// challenges after risk analysis.
	WebKeySettings_INVISIBLE WebKeySettings_IntegrationType = 3
)

// Enum value maps for WebKeySettings_IntegrationType.
var (
	WebKeySettings_IntegrationType_name = map[int32]string{
		0: "INTEGRATION_TYPE_UNSPECIFIED",
		1: "SCORE",
		2: "CHECKBOX",
		3: "INVISIBLE",
	}
	WebKeySettings_IntegrationType_value = map[string]int32{
		"INTEGRATION_TYPE_UNSPECIFIED": 0,
		"SCORE":                        1,
		"CHECKBOX":                     2,
		"INVISIBLE":                    3,
	}
)

func (x WebKeySettings_IntegrationType) Enum() *WebKeySettings_IntegrationType {
	p := new(WebKeySettings_IntegrationType)
	*p = x
	return p
}

func (x WebKeySettings_IntegrationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebKeySettings_IntegrationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[3].Descriptor()
}

func (WebKeySettings_IntegrationType) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[3]
}

func (x WebKeySettings_IntegrationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebKeySettings_IntegrationType.Descriptor instead.
func (WebKeySettings_IntegrationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{14, 0}
}

// Enum that represents the possible challenge frequency and difficulty
// configurations for a web key.
type WebKeySettings_ChallengeSecurityPreference int32

const (
	// Default type that indicates this enum hasn't been specified.
	WebKeySettings_CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED WebKeySettings_ChallengeSecurityPreference = 0
	// Key tends to show fewer and easier challenges.
	WebKeySettings_USABILITY WebKeySettings_ChallengeSecurityPreference = 1
	// Key tends to show balanced (in amount and difficulty) challenges.
	WebKeySettings_BALANCE WebKeySettings_ChallengeSecurityPreference = 2
	// Key tends to show more and harder challenges.
	WebKeySettings_SECURITY WebKeySettings_ChallengeSecurityPreference = 3
)

// Enum value maps for WebKeySettings_ChallengeSecurityPreference.
var (
	WebKeySettings_ChallengeSecurityPreference_name = map[int32]string{
		0: "CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED",
		1: "USABILITY",
		2: "BALANCE",
		3: "SECURITY",
	}
	WebKeySettings_ChallengeSecurityPreference_value = map[string]int32{
		"CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED": 0,
		"USABILITY": 1,
		"BALANCE":   2,
		"SECURITY":  3,
	}
)

func (x WebKeySettings_ChallengeSecurityPreference) Enum() *WebKeySettings_ChallengeSecurityPreference {
	p := new(WebKeySettings_ChallengeSecurityPreference)
	*p = x
	return p
}

func (x WebKeySettings_ChallengeSecurityPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebKeySettings_ChallengeSecurityPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[4].Descriptor()
}

func (WebKeySettings_ChallengeSecurityPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes[4]
}

func (x WebKeySettings_ChallengeSecurityPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebKeySettings_ChallengeSecurityPreference.Descriptor instead.
func (WebKeySettings_ChallengeSecurityPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{14, 1}
}

// The create assessment request message.
type CreateAssessmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which the assessment will be created,
	// in the format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The assessment details.
	Assessment *Assessment `protobuf:"bytes,2,opt,name=assessment,proto3" json:"assessment,omitempty"`
}

func (x *CreateAssessmentRequest) Reset() {
	*x = CreateAssessmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAssessmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAssessmentRequest) ProtoMessage() {}

func (x *CreateAssessmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAssessmentRequest.ProtoReflect.Descriptor instead.
func (*CreateAssessmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAssessmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAssessmentRequest) GetAssessment() *Assessment {
	if x != nil {
		return x.Assessment
	}
	return nil
}

// The request message to annotate an Assessment.
type AnnotateAssessmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Assessment, in the format
	// "projects/{project}/assessments/{assessment}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The annotation that will be assigned to the Event.
	Annotation AnnotateAssessmentRequest_Annotation `protobuf:"varint,2,opt,name=annotation,proto3,enum=google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest_Annotation" json:"annotation,omitempty"`
}

func (x *AnnotateAssessmentRequest) Reset() {
	*x = AnnotateAssessmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateAssessmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateAssessmentRequest) ProtoMessage() {}

func (x *AnnotateAssessmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateAssessmentRequest.ProtoReflect.Descriptor instead.
func (*AnnotateAssessmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{1}
}

func (x *AnnotateAssessmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnnotateAssessmentRequest) GetAnnotation() AnnotateAssessmentRequest_Annotation {
	if x != nil {
		return x.Annotation
	}
	return AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED
}

// Empty response for AnnotateAssessment.
type AnnotateAssessmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnnotateAssessmentResponse) Reset() {
	*x = AnnotateAssessmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateAssessmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateAssessmentResponse) ProtoMessage() {}

func (x *AnnotateAssessmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateAssessmentResponse.ProtoReflect.Descriptor instead.
func (*AnnotateAssessmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{2}
}

// A recaptcha assessment resource.
type Assessment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for the Assessment in the format
	// "projects/{project}/assessments/{assessment}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The event being assessed.
	Event *Event `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	// Output only. The risk analysis result for the event being assessed.
	RiskAnalysis *RiskAnalysis `protobuf:"bytes,3,opt,name=risk_analysis,json=riskAnalysis,proto3" json:"risk_analysis,omitempty"`
	// Output only. Properties of the provided event token.
	TokenProperties *TokenProperties `protobuf:"bytes,4,opt,name=token_properties,json=tokenProperties,proto3" json:"token_properties,omitempty"`
}

func (x *Assessment) Reset() {
	*x = Assessment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Assessment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assessment) ProtoMessage() {}

func (x *Assessment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assessment.ProtoReflect.Descriptor instead.
func (*Assessment) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{3}
}

func (x *Assessment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Assessment) GetEvent() *Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *Assessment) GetRiskAnalysis() *RiskAnalysis {
	if x != nil {
		return x.RiskAnalysis
	}
	return nil
}

func (x *Assessment) GetTokenProperties() *TokenProperties {
	if x != nil {
		return x.TokenProperties
	}
	return nil
}

type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The user response token provided by the reCAPTCHA client-side integration
	// on your site.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Optional. The site key that was used to invoke reCAPTCHA on your site and generate
	// the token.
	SiteKey string `protobuf:"bytes,2,opt,name=site_key,json=siteKey,proto3" json:"site_key,omitempty"`
	// Optional. The user agent present in the request from the user's device related to
	// this event.
	UserAgent string `protobuf:"bytes,3,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// Optional. The IP address in the request from the user's device related to this event.
	UserIpAddress string `protobuf:"bytes,4,opt,name=user_ip_address,json=userIpAddress,proto3" json:"user_ip_address,omitempty"`
	// Optional. The expected action for this type of event. This should be the same action
	// provided at token generation time on client-side platforms already
	// integrated with recaptcha enterprise.
	ExpectedAction string `protobuf:"bytes,5,opt,name=expected_action,json=expectedAction,proto3" json:"expected_action,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{4}
}

func (x *Event) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *Event) GetSiteKey() string {
	if x != nil {
		return x.SiteKey
	}
	return ""
}

func (x *Event) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

func (x *Event) GetUserIpAddress() string {
	if x != nil {
		return x.UserIpAddress
	}
	return ""
}

func (x *Event) GetExpectedAction() string {
	if x != nil {
		return x.ExpectedAction
	}
	return ""
}

// Risk analysis result for an event.
type RiskAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Legitimate event score from 0.0 to 1.0.
	// (1.0 means very likely legitimate traffic while 0.0 means very likely
	// non-legitimate traffic).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// Reasons contributing to the risk analysis verdict.
	Reasons []RiskAnalysis_ClassificationReason `protobuf:"varint,2,rep,packed,name=reasons,proto3,enum=google.cloud.recaptchaenterprise.v1.RiskAnalysis_ClassificationReason" json:"reasons,omitempty"`
}

func (x *RiskAnalysis) Reset() {
	*x = RiskAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RiskAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RiskAnalysis) ProtoMessage() {}

func (x *RiskAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RiskAnalysis.ProtoReflect.Descriptor instead.
func (*RiskAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{5}
}

func (x *RiskAnalysis) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *RiskAnalysis) GetReasons() []RiskAnalysis_ClassificationReason {
	if x != nil {
		return x.Reasons
	}
	return nil
}

type TokenProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the provided user response token is valid. When valid = false, the
	// reason could be specified in invalid_reason or it could also be due to
	// a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
	// used to generate the token was different than the one specified in the
	// assessment).
	Valid bool `protobuf:"varint,1,opt,name=valid,proto3" json:"valid,omitempty"`
	// Reason associated with the response when valid = false.
	InvalidReason TokenProperties_InvalidReason `protobuf:"varint,2,opt,name=invalid_reason,json=invalidReason,proto3,enum=google.cloud.recaptchaenterprise.v1.TokenProperties_InvalidReason" json:"invalid_reason,omitempty"`
	// The timestamp corresponding to the generation of the token.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The hostname of the page on which the token was generated.
	Hostname string `protobuf:"bytes,4,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Action name provided at token generation.
	Action string `protobuf:"bytes,5,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *TokenProperties) Reset() {
	*x = TokenProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TokenProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TokenProperties) ProtoMessage() {}

func (x *TokenProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TokenProperties.ProtoReflect.Descriptor instead.
func (*TokenProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{6}
}

func (x *TokenProperties) GetValid() bool {
	if x != nil {
		return x.Valid
	}
	return false
}

func (x *TokenProperties) GetInvalidReason() TokenProperties_InvalidReason {
	if x != nil {
		return x.InvalidReason
	}
	return TokenProperties_INVALID_REASON_UNSPECIFIED
}

func (x *TokenProperties) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TokenProperties) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *TokenProperties) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

// The create key request message.
type CreateKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which the key will be created, in the
	// format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Information to create a reCAPTCHA Enterprise key.
	Key *Key `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *CreateKeyRequest) Reset() {
	*x = CreateKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateKeyRequest) ProtoMessage() {}

func (x *CreateKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{7}
}

func (x *CreateKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateKeyRequest) GetKey() *Key {
	if x != nil {
		return x.Key
	}
	return nil
}

// The list keys request message.
type ListKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project that contains the keys that will be
	// listed, in the format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of keys to return. Default is 10. Max limit is
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous.
	// ListKeysRequest, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListKeysRequest) Reset() {
	*x = ListKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKeysRequest) ProtoMessage() {}

func (x *ListKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKeysRequest.ProtoReflect.Descriptor instead.
func (*ListKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{8}
}

func (x *ListKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response to request to list keys in a project.
type ListKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key details.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no keys
	// remain in results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListKeysResponse) Reset() {
	*x = ListKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKeysResponse) ProtoMessage() {}

func (x *ListKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKeysResponse.ProtoReflect.Descriptor instead.
func (*ListKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{9}
}

func (x *ListKeysResponse) GetKeys() []*Key {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *ListKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The get key request message.
type GetKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested key, in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetKeyRequest) Reset() {
	*x = GetKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKeyRequest) ProtoMessage() {}

func (x *GetKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKeyRequest.ProtoReflect.Descriptor instead.
func (*GetKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{10}
}

func (x *GetKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The update key request message.
type UpdateKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The key to update.
	Key *Key `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. The mask to control which field of the key get updated. If the mask is not
	// present, all fields will be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateKeyRequest) Reset() {
	*x = UpdateKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateKeyRequest) ProtoMessage() {}

func (x *UpdateKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateKeyRequest) GetKey() *Key {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *UpdateKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The delete key request message.
type DeleteKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the key to be deleted, in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteKeyRequest) Reset() {
	*x = DeleteKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteKeyRequest) ProtoMessage() {}

func (x *DeleteKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A key used to identify and configure applications (web and/or mobile) that
// use reCAPTCHA Enterprise.
type Key struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the Key in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable display name of this key. Modifiable by user.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Platform specific settings for this key. The key can only be used on one
	// platform, the one it has settings for.
	//
	// Types that are assignable to PlatformSettings:
	//	*Key_WebSettings
	//	*Key_AndroidSettings
	//	*Key_IosSettings
	PlatformSettings isKey_PlatformSettings `protobuf_oneof:"platform_settings"`
	// Optional. See <a href="https://cloud.google.com/recaptcha-enterprise/docs/labels">
	// Creating and managing labels</a>.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The timestamp corresponding to the creation of this Key.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *Key) Reset() {
	*x = Key{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Key) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Key) ProtoMessage() {}

func (x *Key) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Key.ProtoReflect.Descriptor instead.
func (*Key) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{13}
}

func (x *Key) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Key) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *Key) GetPlatformSettings() isKey_PlatformSettings {
	if m != nil {
		return m.PlatformSettings
	}
	return nil
}

func (x *Key) GetWebSettings() *WebKeySettings {
	if x, ok := x.GetPlatformSettings().(*Key_WebSettings); ok {
		return x.WebSettings
	}
	return nil
}

func (x *Key) GetAndroidSettings() *AndroidKeySettings {
	if x, ok := x.GetPlatformSettings().(*Key_AndroidSettings); ok {
		return x.AndroidSettings
	}
	return nil
}

func (x *Key) GetIosSettings() *IOSKeySettings {
	if x, ok := x.GetPlatformSettings().(*Key_IosSettings); ok {
		return x.IosSettings
	}
	return nil
}

func (x *Key) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Key) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

type isKey_PlatformSettings interface {
	isKey_PlatformSettings()
}

type Key_WebSettings struct {
	// Settings for keys that can be used by websites.
	WebSettings *WebKeySettings `protobuf:"bytes,3,opt,name=web_settings,json=webSettings,proto3,oneof"`
}

type Key_AndroidSettings struct {
	// Settings for keys that can be used by Android apps.
	AndroidSettings *AndroidKeySettings `protobuf:"bytes,4,opt,name=android_settings,json=androidSettings,proto3,oneof"`
}

type Key_IosSettings struct {
	// Settings for keys that can be used by iOS apps.
	IosSettings *IOSKeySettings `protobuf:"bytes,5,opt,name=ios_settings,json=iosSettings,proto3,oneof"`
}

func (*Key_WebSettings) isKey_PlatformSettings() {}

func (*Key_AndroidSettings) isKey_PlatformSettings() {}

func (*Key_IosSettings) isKey_PlatformSettings() {}

// Settings specific to keys that can be used by websites.
type WebKeySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to true, it means allowed_domains will not be enforced.
	AllowAllDomains bool `protobuf:"varint,3,opt,name=allow_all_domains,json=allowAllDomains,proto3" json:"allow_all_domains,omitempty"`
	// Domains or subdomains of websites allowed to use the key. All subdomains
	// of an allowed domain are automatically allowed. A valid domain requires a
	// host and must not include any path, port, query or fragment.
	// Examples: 'example.com' or 'subdomain.example.com'
	AllowedDomains []string `protobuf:"bytes,1,rep,name=allowed_domains,json=allowedDomains,proto3" json:"allowed_domains,omitempty"`
	// Required. Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
	AllowAmpTraffic bool `protobuf:"varint,2,opt,name=allow_amp_traffic,json=allowAmpTraffic,proto3" json:"allow_amp_traffic,omitempty"`
	// Required. Describes how this key is integrated with the website.
	IntegrationType WebKeySettings_IntegrationType `protobuf:"varint,4,opt,name=integration_type,json=integrationType,proto3,enum=google.cloud.recaptchaenterprise.v1.WebKeySettings_IntegrationType" json:"integration_type,omitempty"`
	// Settings for the frequency and difficulty at which this key triggers
	// captcha challenges. This should only be specified for IntegrationTypes
	// CHECKBOX and INVISIBLE.
	ChallengeSecurityPreference WebKeySettings_ChallengeSecurityPreference `protobuf:"varint,5,opt,name=challenge_security_preference,json=challengeSecurityPreference,proto3,enum=google.cloud.recaptchaenterprise.v1.WebKeySettings_ChallengeSecurityPreference" json:"challenge_security_preference,omitempty"`
}

func (x *WebKeySettings) Reset() {
	*x = WebKeySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebKeySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebKeySettings) ProtoMessage() {}

func (x *WebKeySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebKeySettings.ProtoReflect.Descriptor instead.
func (*WebKeySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{14}
}

func (x *WebKeySettings) GetAllowAllDomains() bool {
	if x != nil {
		return x.AllowAllDomains
	}
	return false
}

func (x *WebKeySettings) GetAllowedDomains() []string {
	if x != nil {
		return x.AllowedDomains
	}
	return nil
}

func (x *WebKeySettings) GetAllowAmpTraffic() bool {
	if x != nil {
		return x.AllowAmpTraffic
	}
	return false
}

func (x *WebKeySettings) GetIntegrationType() WebKeySettings_IntegrationType {
	if x != nil {
		return x.IntegrationType
	}
	return WebKeySettings_INTEGRATION_TYPE_UNSPECIFIED
}

func (x *WebKeySettings) GetChallengeSecurityPreference() WebKeySettings_ChallengeSecurityPreference {
	if x != nil {
		return x.ChallengeSecurityPreference
	}
	return WebKeySettings_CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED
}

// Settings specific to keys that can be used by Android apps.
type AndroidKeySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Android package names of apps allowed to use the key.
	// Example: 'com.companyname.appname'
	AllowedPackageNames []string `protobuf:"bytes,1,rep,name=allowed_package_names,json=allowedPackageNames,proto3" json:"allowed_package_names,omitempty"`
}

func (x *AndroidKeySettings) Reset() {
	*x = AndroidKeySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidKeySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidKeySettings) ProtoMessage() {}

func (x *AndroidKeySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidKeySettings.ProtoReflect.Descriptor instead.
func (*AndroidKeySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{15}
}

func (x *AndroidKeySettings) GetAllowedPackageNames() []string {
	if x != nil {
		return x.AllowedPackageNames
	}
	return nil
}

// Settings specific to keys that can be used by iOS apps.
type IOSKeySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// iOS bundle ids of apps allowed to use the key.
	// Example: 'com.companyname.productname.appname'
	AllowedBundleIds []string `protobuf:"bytes,1,rep,name=allowed_bundle_ids,json=allowedBundleIds,proto3" json:"allowed_bundle_ids,omitempty"`
}

func (x *IOSKeySettings) Reset() {
	*x = IOSKeySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IOSKeySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IOSKeySettings) ProtoMessage() {}

func (x *IOSKeySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IOSKeySettings.ProtoReflect.Descriptor instead.
func (*IOSKeySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP(), []int{16}
}

func (x *IOSKeySettings) GetAllowedBundleIds() []string {
	if x != nil {
		return x.AllowedBundleIds
	}
	return nil
}

var File_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto protoreflect.FileDescriptor

var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbc, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x54, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xce, 0x02, 0x0a, 0x19, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x6e, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x76, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x16, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x45, 0x47,
	0x49, 0x54, 0x49, 0x4d, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x52, 0x41,
	0x55, 0x44, 0x55, 0x4c, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x41, 0x53,
	0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x03, 0x12,
	0x16, 0x0a, 0x12, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x49, 0x4e, 0x43, 0x4f,
	0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x04, 0x22, 0x1c, 0x0a, 0x1a, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8b, 0x03, 0x0a, 0x0a, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x5b, 0x0a, 0x0d, 0x72, 0x69, 0x73, 0x6b, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x69, 0x73,
	0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x72, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x64, 0x0a, 0x10,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x3a, 0x5f, 0xea, 0x41, 0x5c, 0x0a, 0x2d, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x7d, 0x22, 0xc1, 0x01, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x73, 0x69, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x02, 0x0a, 0x0c, 0x52, 0x69, 0x73, 0x6b,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x60,
	0x0a, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x69, 0x73, 0x6b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73,
	0x22, 0xb8, 0x01, 0x0a, 0x14, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4c, 0x41,
	0x53, 0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x45,
	0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x4f, 0x4f, 0x5f, 0x4d, 0x55, 0x43, 0x48, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43,
	0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45, 0x44,
	0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x41, 0x54, 0x54, 0x45, 0x52, 0x4e, 0x53, 0x10,
	0x04, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f, 0x57, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x44, 0x45,
	0x4e, 0x43, 0x45, 0x5f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x10, 0x05, 0x22, 0x83, 0x03, 0x0a, 0x0f,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x12, 0x69, 0x0a, 0x0e, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2e, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x52, 0x0d, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7e, 0x0a, 0x0d, 0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x45,
	0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x4e,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x4d, 0x41, 0x4c, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a,
	0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x55,
	0x50, 0x45, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x22, 0xa0, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x22, 0xa4, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x78, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3c, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x53, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x10, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x56, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x82, 0x05, 0x0a, 0x03, 0x4b,
	0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0c, 0x77, 0x65, 0x62,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x77, 0x65, 0x62, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x64, 0x0a, 0x10, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4b, 0x65, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x69, 0x6f, 0x73,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x4f, 0x53, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6f, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x4a,
	0xea, 0x41, 0x47, 0x0a, 0x26, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0xf6, 0x04, 0x0a, 0x0e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x6c, 0x6c, 0x5f,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6c, 0x6c, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x61, 0x6d, 0x70, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6d,
	0x70, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x12, 0x73, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x93, 0x01,
	0x0a, 0x1d, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x4b,
	0x65, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x1b, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x22, 0x5b, 0x0a, 0x0f, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x43, 0x4f, 0x52,
	0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x42, 0x4f, 0x58, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x56, 0x49, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x03,
	0x22, 0x76, 0x0a, 0x1b, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x53, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x2d, 0x0a, 0x29, 0x43, 0x48, 0x41, 0x4c, 0x4c, 0x45, 0x4e, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x43,
	0x55, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x55, 0x53, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x45,
	0x43, 0x55, 0x52, 0x49, 0x54, 0x59, 0x10, 0x03, 0x22, 0x48, 0x0a, 0x12, 0x41, 0x6e, 0x64, 0x72,
	0x6f, 0x69, 0x64, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x22, 0x3e, 0x0a, 0x0e, 0x49, 0x4f, 0x53, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x49,
	0x64, 0x73, 0x32, 0x92, 0x0a, 0x0a, 0x1a, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xce, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x23, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x3a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41,
	0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0xe0, 0x01, 0x0a, 0x12, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x97, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74,
	0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4b, 0x65, 0x79, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x22, 0x1c, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x3a, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x9d, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x65, 0x79,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x12,
	0x8c, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74,
	0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e,
	0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9b,
	0x01, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x65, 0x79, 0x22, 0x2d, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x27, 0x32, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x80, 0x01, 0x0a,
	0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74,
	0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1e, 0x2a, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x1a,
	0x56, 0xca, 0x41, 0x22, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x93, 0x02, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x52,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x52, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68,
	0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescOnce sync.Once
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData = file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc
)

func file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescGZIP() []byte {
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescOnce.Do(func() {
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData)
	})
	return file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDescData
}

var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_goTypes = []interface{}{
	(AnnotateAssessmentRequest_Annotation)(0),       // 0: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.Annotation
	(RiskAnalysis_ClassificationReason)(0),          // 1: google.cloud.recaptchaenterprise.v1.RiskAnalysis.ClassificationReason
	(TokenProperties_InvalidReason)(0),              // 2: google.cloud.recaptchaenterprise.v1.TokenProperties.InvalidReason
	(WebKeySettings_IntegrationType)(0),             // 3: google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType
	(WebKeySettings_ChallengeSecurityPreference)(0), // 4: google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference
	(*CreateAssessmentRequest)(nil),                 // 5: google.cloud.recaptchaenterprise.v1.CreateAssessmentRequest
	(*AnnotateAssessmentRequest)(nil),               // 6: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest
	(*AnnotateAssessmentResponse)(nil),              // 7: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentResponse
	(*Assessment)(nil),                              // 8: google.cloud.recaptchaenterprise.v1.Assessment
	(*Event)(nil),                                   // 9: google.cloud.recaptchaenterprise.v1.Event
	(*RiskAnalysis)(nil),                            // 10: google.cloud.recaptchaenterprise.v1.RiskAnalysis
	(*TokenProperties)(nil),                         // 11: google.cloud.recaptchaenterprise.v1.TokenProperties
	(*CreateKeyRequest)(nil),                        // 12: google.cloud.recaptchaenterprise.v1.CreateKeyRequest
	(*ListKeysRequest)(nil),                         // 13: google.cloud.recaptchaenterprise.v1.ListKeysRequest
	(*ListKeysResponse)(nil),                        // 14: google.cloud.recaptchaenterprise.v1.ListKeysResponse
	(*GetKeyRequest)(nil),                           // 15: google.cloud.recaptchaenterprise.v1.GetKeyRequest
	(*UpdateKeyRequest)(nil),                        // 16: google.cloud.recaptchaenterprise.v1.UpdateKeyRequest
	(*DeleteKeyRequest)(nil),                        // 17: google.cloud.recaptchaenterprise.v1.DeleteKeyRequest
	(*Key)(nil),                                     // 18: google.cloud.recaptchaenterprise.v1.Key
	(*WebKeySettings)(nil),                          // 19: google.cloud.recaptchaenterprise.v1.WebKeySettings
	(*AndroidKeySettings)(nil),                      // 20: google.cloud.recaptchaenterprise.v1.AndroidKeySettings
	(*IOSKeySettings)(nil),                          // 21: google.cloud.recaptchaenterprise.v1.IOSKeySettings
	nil,                                             // 22: google.cloud.recaptchaenterprise.v1.Key.LabelsEntry
	(*timestamp.Timestamp)(nil),                     // 23: google.protobuf.Timestamp
	(*field_mask.FieldMask)(nil),                    // 24: google.protobuf.FieldMask
	(*empty.Empty)(nil),                             // 25: google.protobuf.Empty
}
var file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_depIdxs = []int32{
	8,  // 0: google.cloud.recaptchaenterprise.v1.CreateAssessmentRequest.assessment:type_name -> google.cloud.recaptchaenterprise.v1.Assessment
	0,  // 1: google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.annotation:type_name -> google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest.Annotation
	9,  // 2: google.cloud.recaptchaenterprise.v1.Assessment.event:type_name -> google.cloud.recaptchaenterprise.v1.Event
	10, // 3: google.cloud.recaptchaenterprise.v1.Assessment.risk_analysis:type_name -> google.cloud.recaptchaenterprise.v1.RiskAnalysis
	11, // 4: google.cloud.recaptchaenterprise.v1.Assessment.token_properties:type_name -> google.cloud.recaptchaenterprise.v1.TokenProperties
	1,  // 5: google.cloud.recaptchaenterprise.v1.RiskAnalysis.reasons:type_name -> google.cloud.recaptchaenterprise.v1.RiskAnalysis.ClassificationReason
	2,  // 6: google.cloud.recaptchaenterprise.v1.TokenProperties.invalid_reason:type_name -> google.cloud.recaptchaenterprise.v1.TokenProperties.InvalidReason
	23, // 7: google.cloud.recaptchaenterprise.v1.TokenProperties.create_time:type_name -> google.protobuf.Timestamp
	18, // 8: google.cloud.recaptchaenterprise.v1.CreateKeyRequest.key:type_name -> google.cloud.recaptchaenterprise.v1.Key
	18, // 9: google.cloud.recaptchaenterprise.v1.ListKeysResponse.keys:type_name -> google.cloud.recaptchaenterprise.v1.Key
	18, // 10: google.cloud.recaptchaenterprise.v1.UpdateKeyRequest.key:type_name -> google.cloud.recaptchaenterprise.v1.Key
	24, // 11: google.cloud.recaptchaenterprise.v1.UpdateKeyRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 12: google.cloud.recaptchaenterprise.v1.Key.web_settings:type_name -> google.cloud.recaptchaenterprise.v1.WebKeySettings
	20, // 13: google.cloud.recaptchaenterprise.v1.Key.android_settings:type_name -> google.cloud.recaptchaenterprise.v1.AndroidKeySettings
	21, // 14: google.cloud.recaptchaenterprise.v1.Key.ios_settings:type_name -> google.cloud.recaptchaenterprise.v1.IOSKeySettings
	22, // 15: google.cloud.recaptchaenterprise.v1.Key.labels:type_name -> google.cloud.recaptchaenterprise.v1.Key.LabelsEntry
	23, // 16: google.cloud.recaptchaenterprise.v1.Key.create_time:type_name -> google.protobuf.Timestamp
	3,  // 17: google.cloud.recaptchaenterprise.v1.WebKeySettings.integration_type:type_name -> google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType
	4,  // 18: google.cloud.recaptchaenterprise.v1.WebKeySettings.challenge_security_preference:type_name -> google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference
	5,  // 19: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateAssessment:input_type -> google.cloud.recaptchaenterprise.v1.CreateAssessmentRequest
	6,  // 20: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.AnnotateAssessment:input_type -> google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest
	12, // 21: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateKey:input_type -> google.cloud.recaptchaenterprise.v1.CreateKeyRequest
	13, // 22: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListKeys:input_type -> google.cloud.recaptchaenterprise.v1.ListKeysRequest
	15, // 23: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.GetKey:input_type -> google.cloud.recaptchaenterprise.v1.GetKeyRequest
	16, // 24: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.UpdateKey:input_type -> google.cloud.recaptchaenterprise.v1.UpdateKeyRequest
	17, // 25: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.DeleteKey:input_type -> google.cloud.recaptchaenterprise.v1.DeleteKeyRequest
	8,  // 26: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateAssessment:output_type -> google.cloud.recaptchaenterprise.v1.Assessment
	7,  // 27: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.AnnotateAssessment:output_type -> google.cloud.recaptchaenterprise.v1.AnnotateAssessmentResponse
	18, // 28: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.CreateKey:output_type -> google.cloud.recaptchaenterprise.v1.Key
	14, // 29: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.ListKeys:output_type -> google.cloud.recaptchaenterprise.v1.ListKeysResponse
	18, // 30: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.GetKey:output_type -> google.cloud.recaptchaenterprise.v1.Key
	18, // 31: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.UpdateKey:output_type -> google.cloud.recaptchaenterprise.v1.Key
	25, // 32: google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService.DeleteKey:output_type -> google.protobuf.Empty
	26, // [26:33] is the sub-list for method output_type
	19, // [19:26] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_init() }
func file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_init() {
	if File_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAssessmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateAssessmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateAssessmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Assessment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RiskAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TokenProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Key); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebKeySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidKeySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IOSKeySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*Key_WebSettings)(nil),
		(*Key_AndroidSettings)(nil),
		(*Key_IosSettings)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_goTypes,
		DependencyIndexes: file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_depIdxs,
		EnumInfos:         file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_enumTypes,
		MessageInfos:      file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_msgTypes,
	}.Build()
	File_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto = out.File
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_rawDesc = nil
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_goTypes = nil
	file_google_cloud_recaptchaenterprise_v1_recaptchaenterprise_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RecaptchaEnterpriseServiceClient is the client API for RecaptchaEnterpriseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecaptchaEnterpriseServiceClient interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// Returns the specified key.
	GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Updates the specified key.
	UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Deletes the specified key.
	DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type recaptchaEnterpriseServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRecaptchaEnterpriseServiceClient(cc grpc.ClientConnInterface) RecaptchaEnterpriseServiceClient {
	return &recaptchaEnterpriseServiceClient{cc}
}

func (c *recaptchaEnterpriseServiceClient) CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error) {
	out := new(Assessment)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error) {
	out := new(AnnotateAssessmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AnnotateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecaptchaEnterpriseServiceServer is the server API for RecaptchaEnterpriseService service.
type RecaptchaEnterpriseServiceServer interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(context.Context, *CreateKeyRequest) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// Returns the specified key.
	GetKey(context.Context, *GetKeyRequest) (*Key, error)
	// Updates the specified key.
	UpdateKey(context.Context, *UpdateKeyRequest) (*Key, error)
	// Deletes the specified key.
	DeleteKey(context.Context, *DeleteKeyRequest) (*empty.Empty, error)
}

// UnimplementedRecaptchaEnterpriseServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRecaptchaEnterpriseServiceServer struct {
}

func (*UnimplementedRecaptchaEnterpriseServiceServer) CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAssessment not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateAssessment not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) CreateKey(context.Context, *CreateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeys not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) GetKey(context.Context, *GetKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) UpdateKey(context.Context, *UpdateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) DeleteKey(context.Context, *DeleteKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKey not implemented")
}

func RegisterRecaptchaEnterpriseServiceServer(s *grpc.Server, srv RecaptchaEnterpriseServiceServer) {
	s.RegisterService(&_RecaptchaEnterpriseService_serviceDesc, srv)
}

func _RecaptchaEnterpriseService_CreateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, req.(*CreateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_AnnotateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AnnotateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, req.(*AnnotateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_CreateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_GetKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, req.(*GetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_UpdateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, req.(*UpdateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_DeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, req.(*DeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecaptchaEnterpriseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService",
	HandlerType: (*RecaptchaEnterpriseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAssessment",
			Handler:    _RecaptchaEnterpriseService_CreateAssessment_Handler,
		},
		{
			MethodName: "AnnotateAssessment",
			Handler:    _RecaptchaEnterpriseService_AnnotateAssessment_Handler,
		},
		{
			MethodName: "CreateKey",
			Handler:    _RecaptchaEnterpriseService_CreateKey_Handler,
		},
		{
			MethodName: "ListKeys",
			Handler:    _RecaptchaEnterpriseService_ListKeys_Handler,
		},
		{
			MethodName: "GetKey",
			Handler:    _RecaptchaEnterpriseService_GetKey_Handler,
		},
		{
			MethodName: "UpdateKey",
			Handler:    _RecaptchaEnterpriseService_UpdateKey_Handler,
		},
		{
			MethodName: "DeleteKey",
			Handler:    _RecaptchaEnterpriseService_DeleteKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto",
}
