// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/actions/type/date_range.proto

package date_range

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Represents a range based on whole or partial calendar dates, e.g. the
// duration of a hotel reservation or the Common Era. This can represent:
//
// * A range between full dates, e.g. the duration of a hotel reservation
// * A range between years, e.g. a historical era
// * A range between year/month dates, e.g. the duration of a job on a resume
// * A range beginning in a year, e.g. the Common Era
// * A range ending on a specific date, e.g. the period of time before an event
//
// While [google.type.Date][google.type.Date] allows zero years, DateRange does not. Year must
// always be non-zero.
//
// End cannot be chronologically before start. For example, if start has year
// 2000, end cannot have year 1999.
//
// When both set, start and end must have exactly the same precision. That is,
// they must have the same fields populated with non-zero values. For example,
// if start specifies only year and month, then end must also specify only year
// and month (but not day).
//
// The date range is inclusive. That is, the dates specified by start and end
// are part of the date range. For example, the date January 1, 2000 falls
// within any date with start or end equal to January 1, 2000. When determining
// whether a date is inside a date range, the date should only be compared to
// start and end when those values are set.
//
// When a date and date range are specified to different degrees of precision,
// the rules for evaluating whether that date is inside the date range are as
// follows:
//
//  * When comparing the date to the start of the date range, unspecified months
//    should be replaced with 1, and unspecified days should be replaced with 1.
//    For example, the year 2000 is within the date range with start equal to
//    January 1, 2000 and no end. And the date January 1, 2000 is within the
//    date range with start equal to the year 2000 and no end.
//
//  * When comparing the date to the end of the date range, unspecified months
//    should be replaced with 12, and unspecified days should be replaced with
//    the last valid day for the month/year. For example, the year 2000 is
//    within the date range with start equal to January 1, 1999 and end equal to
//    December 31, 2000. And the date December 31, 2001 is within the date range
//    with start equal to the year 2000 and end equal to the year 2001.
//
// The semantics of start and end are the same as those of [google.type.Date][google.type.Date],
// except that year must always be non-zero in DateRange.
type DateRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date at which the date range begins. If unset, the date range has no
	// beginning bound.
	Start *date.Date `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// Date at which the date range ends. If unset, the date range has no ending
	// bound.
	End *date.Date `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *DateRange) Reset() {
	*x = DateRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_type_date_range_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateRange) ProtoMessage() {}

func (x *DateRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_type_date_range_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateRange.ProtoReflect.Descriptor instead.
func (*DateRange) Descriptor() ([]byte, []int) {
	return file_google_actions_type_date_range_proto_rawDescGZIP(), []int{0}
}

func (x *DateRange) GetStart() *date.Date {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *DateRange) GetEnd() *date.Date {
	if x != nil {
		return x.End
	}
	return nil
}

var File_google_actions_type_date_range_proto protoreflect.FileDescriptor

var file_google_actions_type_date_range_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x59, 0x0a, 0x09, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x27, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x23, 0x0a, 0x03, 0x65, 0x6e, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x42, 0x75,
	0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0e, 0x44, 0x61, 0x74, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x3b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0xa2, 0x02, 0x05,
	0x41, 0x4f, 0x47, 0x54, 0x50, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_type_date_range_proto_rawDescOnce sync.Once
	file_google_actions_type_date_range_proto_rawDescData = file_google_actions_type_date_range_proto_rawDesc
)

func file_google_actions_type_date_range_proto_rawDescGZIP() []byte {
	file_google_actions_type_date_range_proto_rawDescOnce.Do(func() {
		file_google_actions_type_date_range_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_type_date_range_proto_rawDescData)
	})
	return file_google_actions_type_date_range_proto_rawDescData
}

var file_google_actions_type_date_range_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_type_date_range_proto_goTypes = []interface{}{
	(*DateRange)(nil), // 0: google.actions.type.DateRange
	(*date.Date)(nil), // 1: google.type.Date
}
var file_google_actions_type_date_range_proto_depIdxs = []int32{
	1, // 0: google.actions.type.DateRange.start:type_name -> google.type.Date
	1, // 1: google.actions.type.DateRange.end:type_name -> google.type.Date
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_actions_type_date_range_proto_init() }
func file_google_actions_type_date_range_proto_init() {
	if File_google_actions_type_date_range_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_type_date_range_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_type_date_range_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_type_date_range_proto_goTypes,
		DependencyIndexes: file_google_actions_type_date_range_proto_depIdxs,
		MessageInfos:      file_google_actions_type_date_range_proto_msgTypes,
	}.Build()
	File_google_actions_type_date_range_proto = out.File
	file_google_actions_type_date_range_proto_rawDesc = nil
	file_google_actions_type_date_range_proto_goTypes = nil
	file_google_actions_type_date_range_proto_depIdxs = nil
}
